/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.display.findlists;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.text.TextViewer;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SetsWithKanjiFinder {
    private final FumikoDataStructures dataStructures;
    private final Component thisPanelUsingDialog;

    public SetsWithKanjiFinder(FumikoDataStructures fumikoDataStructures, Component component) {
        this.dataStructures = fumikoDataStructures;
        this.thisPanelUsingDialog = component;
    }

    public void findKanjiSetsWithKanji(Kanji kanji) {
        List<KanjiSet> list = this.dataStructures.getKanjiSets();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (KanjiSet object : list) {
            if (!object.containes(kanji)) continue;
            arrayList.add(object.getName());
        }
        if (arrayList.isEmpty()) {
            GuiTools.informUser(this.thisPanelUsingDialog, "Keine Kanji-Menge gefunden.", "Das Kanji \u300c" + kanji.getCharacter() + "\u300d kommt in keiner Kanji-Menge vor.");
        } else {
            String string = "Das Kanji \u300c" + kanji.getCharacter() + "\u300d kommt in den folgenden Kanji-Mengen vor:\n\n" + Text.joinWithLineBreak(arrayList);
            TextViewer textViewer = new TextViewer("Kanji-Mengen mit dem Kanji \u300c" + kanji.getCharacter() + "\u300d", this.thisPanelUsingDialog.getLocation());
            textViewer.setText(string);
            textViewer.setVisible(true);
        }
    }
}

