/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.tools.SelectionsHelper;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.swing.ui.pages.DatasetsOnPages;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.io.KanjiSetFileRenamer;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.ui.components.bars.KanjiBar;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset.filter.KanjiFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class KanjiSetEditor
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1300, 900);
    private static final int NAME_MIN_WIDTH = 450;
    private final KanjiSet kanjiSet;
    private final List<Kanji> kanjiSetList;
    private final List<String> notAllowedNames;
    private final VocabularyTrainerLogic logic;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final KanjiFilterPanel kanjiSetFilter;
    private final StringSelection nameSelection;
    private final StringSelection groupSelection;
    private final DatasetsOnPages<Kanji> pages;
    private final JPanel kanjiOfSetPanel;
    private final JScrollPane kanjiOfSetScroll;
    private final Map<Kanji, KanjiBar> barByKanji;
    private final JButton toggleMoveButtonsButton;
    private boolean showMoveButtonsOnBars;

    public KanjiSetEditor(KanjiSet kanjiSet, List<String> list2, VocabularyTrainerLogic vocabularyTrainerLogic, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point) {
        super(point, fumikoUiObjects.getProgramImage(), KanjiSetEditor.createTitle(kanjiSet.getName()), DIALOG_DIMENSION);
        this.addClosingWindowListener(() -> this.quit());
        this.kanjiSet = kanjiSet;
        this.notAllowedNames = list2;
        this.logic = vocabularyTrainerLogic;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.barByKanji = new HashMap<Kanji, KanjiBar>();
        this.kanjiSetList = new ArrayList<Kanji>();
        this.kanjiSetList.addAll(kanjiSet.getSet());
        this.nameSelection = new StringSelection("Name der Kanji-Menge");
        this.nameSelection.setText(kanjiSet.getName());
        this.groupSelection = new StringSelection("Gruppe der Kanji-Menge");
        this.groupSelection.setText(kanjiSet.getGroup());
        this.kanjiSetFilter = new KanjiFilterPanel(Kanji.getAllKanjiAsList(), list -> this.reactOnFilteredKanjiList(list));
        this.toggleMoveButtonsButton = new JButton();
        this.showMoveButtonsOnBars = false;
        int n = 20;
        int n2 = 3;
        this.pages = new DatasetsOnPages<Kanji>(this.kanjiSetFilter.createFilteredKanjiList(), kanji -> this.createDatasetUi((Kanji)((Object)kanji)), n, n2);
        this.kanjiOfSetPanel = new JPanel();
        this.kanjiOfSetScroll = GuiTools.createScrollPane(this.kanjiOfSetPanel);
        this.init();
        this.filterKanjiList();
        this.showKanjiInSet();
        this.fillDialog();
    }

    private static String createTitle(String string) {
        return "Bearbeiten der Kanji-Menge '" + string + "'";
    }

    private void setTitle() {
        this.setTitle(KanjiSetEditor.createTitle(this.nameSelection.getTrimmedText()));
    }

    private Component createDatasetUi(Kanji kanji) {
        KanjiBar kanjiBar = new KanjiBar(kanji, () -> this.addKanji(kanji), this, this.dataStructures, this.uiObjects, () -> this.getLocation());
        kanjiBar.useButtonAsAddKanjiToList();
        if (this.kanjiSetList.contains((Object)kanji)) {
            kanjiBar.disable();
        }
        kanjiBar.createGui();
        this.barByKanji.put(kanji, kanjiBar);
        return kanjiBar.getPanel();
    }

    private void addKanji(Kanji kanji) {
        if (!this.kanjiSetList.contains((Object)kanji)) {
            this.addNotContainedKanji(kanji);
        }
    }

    private void addNotContainedKanji(Kanji kanji) {
        this.kanjiSetList.add(kanji);
        this.showKanjiInSet();
        KanjiBar kanjiBar = this.barByKanji.get((Object)kanji);
        kanjiBar.disable();
        this.kanjiSetFilter.requestFocusInSearchFieldLater();
    }

    private void init() {
        this.initKanjiOfSetPanel();
        this.initNameSelection();
        this.initGroupSelection();
        this.initToggleButton();
        this.setRightShowAndHideButtonTexts();
        this.setTitle();
    }

    private void initKanjiOfSetPanel() {
        this.kanjiOfSetPanel.setLayout(new VerticalLayout(3, 3));
    }

    private void initNameSelection() {
        SelectionsHelper.initSelectionAsEditor(this.nameSelection);
    }

    private void initGroupSelection() {
        SelectionsHelper.initSelectionAsEditor(this.groupSelection);
    }

    private void initToggleButton() {
        this.toggleMoveButtonsButton.addActionListener(actionEvent -> this.toggleMoveButtons());
    }

    private void toggleMoveButtons() {
        this.showMoveButtonsOnBars = !this.showMoveButtonsOnBars;
        this.setRightShowAndHideButtonTexts();
        this.showKanjiInSet();
    }

    private void setRightShowAndHideButtonTexts() {
        String string = "einblenden";
        String string2 = "ausblenden";
        String string3 = this.showMoveButtonsOnBars ? string2 : string;
        this.toggleMoveButtonsButton.setText("Die Buttons zum Verschieben " + string3);
    }

    private void showKanjiInSet() {
        this.kanjiOfSetPanel.removeAll();
        for (Kanji kanji : this.kanjiSetList) {
            KanjiBar kanjiBar = new KanjiBar(kanji, () -> this.deleteFromSet(kanji), this, this.dataStructures, this.uiObjects, () -> this.getLocation());
            kanjiBar.useButtonAsDeletion();
            kanjiBar.showMoveButtonsOnBars(this.showMoveButtonsOnBars);
            kanjiBar.createGui();
            this.kanjiOfSetPanel.add(kanjiBar.getPanel());
        }
        this.kanjiOfSetPanel.repaint();
        this.kanjiOfSetPanel.validate();
        this.kanjiOfSetPanel.invalidate();
        this.kanjiOfSetScroll.repaint();
        this.kanjiOfSetScroll.validate();
        this.kanjiOfSetScroll.invalidate();
    }

    private void deleteFromSet(Kanji kanji) {
        this.kanjiSetList.remove((Object)kanji);
        this.showKanjiInSet();
        if (this.barByKanji.containsKey((Object)kanji)) {
            KanjiBar kanjiBar = this.barByKanji.get((Object)kanji);
            kanjiBar.enable();
        }
        this.kanjiSetFilter.requestFocusInSearchFieldLater();
    }

    private void filterKanjiList() {
        List<Kanji> list = this.kanjiSetFilter.createFilteredKanjiList();
        this.reactOnFilteredKanjiList(list);
    }

    private void reactOnFilteredKanjiList(List<Kanji> list) {
        if (list.isEmpty()) {
            GuiTools.informUser(this.getWindowAsComponent(), "Keine Vokabeln gefunden", "Die Suchkriterien f\u00fchren zu einer leeren Liste von Vokabeln, daher wird diese nicht angezeigt.");
        } else {
            this.pages.setOtherDatasets(list);
        }
    }

    @Override
    protected void populateDialog() {
        this.add(this.createKanjiSelectionAndSetPart(), "Center");
        this.add(this.createButtonPart(), "South");
        this.pages.addOwnExtension(this.createPagesExtensionPart());
    }

    private Component createKanjiSelectionAndSetPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createKanjiSelectionPart(), "Center");
        jPanel.add(this.createKanjiSetPart(), "East");
        return jPanel;
    }

    private Component createKanjiSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Auswahl der Kanji", jPanel);
        jPanel.add((Component)this.kanjiSetFilter.getPanel(), "North");
        jPanel.add(this.pages.getPanel(), "Center");
        return jPanel;
    }

    private Component createKanjiSetPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Die Kanji-Menge", jPanel);
        jPanel.add(this.createKanjiSetUpperPart(), "North");
        jPanel.add((Component)this.kanjiOfSetScroll, "Center");
        return jPanel;
    }

    private Component createKanjiSetUpperPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createNameAndGroupPart(), "Center");
        jPanel.add((Component)this.toggleMoveButtonsButton, "South");
        return jPanel;
    }

    private Component createNameAndGroupPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createDummyWidthLabel());
        jPanel.add(this.nameSelection.getPanel());
        jPanel.add(this.groupSelection.getPanel());
        return jPanel;
    }

    private Component createDummyWidthLabel() {
        JLabel jLabel = new JLabel("");
        jLabel.setPreferredSize(new Dimension(450, 0));
        return jLabel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }

    private Component createOkButton() {
        JButton jButton = new JButton(" Ok ");
        GuiTools.boldFont(jButton);
        GuiTools.biggerFont(jButton, 5);
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        Object object;
        String string = this.kanjiSet.getName();
        String string2 = this.nameSelection.getTrimmedText();
        String string3 = this.groupSelection.getTrimmedText();
        if (!string2.equals(string)) {
            if (string2.isBlank() || KanjiSet.determineBareFilename(string2).isBlank() || this.notAllowedNames.contains(string2)) {
                object = "Die Kanji-Menge wurde nicht umbenannt";
                String string4 = "Der eingegebene Name '" + string2 + "' ist bereits vorhanden oder resultiert in einem leeren Dateinamen.\nDie Kanji-Menge wurde daher nicht umbenannt. Die restlichen \u00c4nderungen werden aber \u00fcbernommen.";
                GuiTools.informUser(this.getWindowAsComponent(), (String)object, string4);
                string2 = string;
            } else if (!string2.equals(string)) {
                KanjiSetFileRenamer.renameListFile(string, string2);
                this.kanjiSet.setName(string2);
            }
        }
        this.kanjiSet.setGroup(string3);
        object = this.kanjiSet.getSet();
        object.clear();
        object.addAll(this.kanjiSetList);
        this.saveKanjiLists();
        this.quit();
    }

    private void saveKanjiLists() {
        this.logic.saveKanjiSets();
    }

    private Component createPagesExtensionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 3, 3));
        jPanel.add(this.createSelectAllButton());
        jPanel.add(this.createDeselectAllButton());
        jPanel.add(this.createAddSelectedButton());
        jPanel.add(this.createAddAllButton());
        return jPanel;
    }

    private Component createSelectAllButton() {
        JButton jButton = new JButton("select all");
        jButton.addActionListener(actionEvent -> this.selectAll());
        return jButton;
    }

    private void selectAll() {
        boolean bl = true;
        this.setBarsOnActualPageSelected(bl);
    }

    private Component createDeselectAllButton() {
        JButton jButton = new JButton("deselect all");
        jButton.addActionListener(actionEvent -> this.deselectAll());
        return jButton;
    }

    private void deselectAll() {
        boolean bl = false;
        this.setBarsOnActualPageSelected(bl);
    }

    private void setBarsOnActualPageSelected(boolean bl) {
        for (Kanji kanji : this.pages.getDatasetsFromActualPage()) {
            KanjiBar kanjiBar = this.barByKanji.get((Object)kanji);
            kanjiBar.setSelected(bl);
        }
    }

    private Component createAddSelectedButton() {
        JButton jButton = new JButton("add selected");
        jButton.addActionListener(actionEvent -> this.addSelected());
        return jButton;
    }

    private void addSelected() {
        ArrayList<KanjiBar> arrayList = new ArrayList<KanjiBar>();
        for (Kanji kanji : this.pages.getDatasetsFromActualPage()) {
            KanjiBar kanjiBar = this.barByKanji.get((Object)kanji);
            if (!kanjiBar.isSelected()) continue;
            this.addKanji(kanji);
            arrayList.add(kanjiBar);
        }
        this.disableAddedBars(arrayList);
    }

    private Component createAddAllButton() {
        JButton jButton = new JButton("add all from active Page");
        jButton.addActionListener(actionEvent -> this.addAll());
        return jButton;
    }

    private void addAll() {
        ArrayList<KanjiBar> arrayList = new ArrayList<KanjiBar>();
        for (Kanji kanji : this.pages.getDatasetsFromActualPage()) {
            this.addKanji(kanji);
            KanjiBar kanjiBar = this.barByKanji.get((Object)kanji);
            arrayList.add(kanjiBar);
        }
        this.disableAddedBars(arrayList);
    }

    private void disableAddedBars(List<KanjiBar> list) {
        for (KanjiBar kanjiBar : list) {
            kanjiBar.setSelected(false);
            kanjiBar.disable();
        }
    }

    public void moveBarToFirst(Kanji kanji) {
        int n = this.kanjiSetList.indexOf((Object)kanji);
        this.kanjiSetList.remove(n);
        this.kanjiSetList.add(0, kanji);
        this.showKanjiInSet();
    }

    public void moveBarUp(Kanji kanji) {
        int n = this.kanjiSetList.indexOf((Object)kanji);
        this.kanjiSetList.remove(n);
        this.kanjiSetList.add(n - 1, kanji);
        this.showKanjiInSet();
    }

    public void moveBarDown(Kanji kanji) {
        int n = this.kanjiSetList.indexOf((Object)kanji);
        this.kanjiSetList.remove(n);
        this.kanjiSetList.add(n + 1, kanji);
        this.showKanjiInSet();
    }

    public void moveBarToLast(Kanji kanji) {
        int n = this.kanjiSetList.indexOf((Object)kanji);
        this.kanjiSetList.remove(n);
        this.kanjiSetList.add(kanji);
        this.showKanjiInSet();
    }

    public boolean canBarMoveUp(Kanji kanji) {
        int n = this.kanjiSetList.indexOf((Object)kanji);
        return n > 0;
    }

    public boolean canBarMoveDown(Kanji kanji) {
        int n = this.kanjiSetList.indexOf((Object)kanji);
        return n < this.kanjiSetList.size() - 1;
    }
}

