/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.options.colors.eleven;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.color.data.ColorModificationType;
import de.duehl.vocabulary.japanese.common.color.data.DefaultColors;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.ui.dialog.options.colors.eleven.OneOfElevenColorUi;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ElevenColorsOptionsUi {
    private static final String COLOR_MODIFICATION_EXPLANATION = "Hier werden Farben in der Form von sogenannten RGB-Farben verwendet.\nDas R steht f\u00fcr 'red', also Rot, das G f\u00fcr 'green', also Gr\u00fcn und das\nB f\u00fcr 'blue', also Blau.\nJedem dieser Werte ist eine Zahl zwischen 0 und 255 (einschlie\u00dflich)\nzugeordnet. Dabei entsprechen die Werte (0, 0, 0) der Farbe Schwarz und\ndie Werte (255, 255, 255) der Farbe Wei\u00df. (255, 0, 0) entspricht einem\nknalligen Rot und so weiter.\n\nUm aus den hinterlegten Farben Vorder- bzw. Hintergrundfarben zu machen,\nwerden sie f\u00fcr Vordergrundfarben etwas abgedunkelt und f\u00fcr Hintergrund-\nFarben aufgehellt, so dass man alle Texte auf so einem Hintergrund noch\ngut lesen kann.\n\nF\u00fcr diese Farb-Modifikation habe ich zwei unterschiedliche Vorgehensweisen,\neinmal eine 'additive' und einmal eine 'multiplikative'.\n\nBei der additiven Farb-Modifikation wird zu jedem der drei Farbwerte (also\nf\u00fcr Rot, Gr\u00fcn und Blau) das festgelegte Delta addiert (f\u00fcr die Vordergrund-\nfarben ist das Delta negativ, damit die Farben dunkler werden, f\u00fcr die\nHintergrundfarben ist es positiv, damit die Farben heller werden).\nDabei werden alle Werte unter 0 auf 0 und alle Werte \u00fcber 255 auf 255 gesetzt.\n\nBei der multiplikativen Farb-Modifikation wird f\u00fcr jeden der drei Farbwerte\n(also f\u00fcr Rot, Gr\u00fcn und Blau) das normale Intervall von [0, 255] auf\n[0, 255-|delta|] bzw. [0+|delta|, 255 skaliert, damit die Verh\u00e4ltnism\u00e4\u00dfig-\nkeiten der Farben erhalten bleiben.\n";
    private final VocableColors vocableColors;
    private int deltaForForegroundColor;
    private int deltaForBackgroundColor;
    private final JPanel panel;
    private final JCheckBox multiplicativeColorModificationCheckBox;
    private final StringSelection deltaForForegroundColorSelection;
    private final StringSelection deltaForBackgroundColorSelection;
    private List<OneOfElevenColorUi> colorUis;

    public ElevenColorsOptionsUi(VocableColors vocableColors) {
        this.vocableColors = vocableColors;
        this.panel = new JPanel();
        this.multiplicativeColorModificationCheckBox = new JCheckBox("Die multiplikative Farb-Modifikation wird (statt der additiven) verwendet.");
        this.deltaForForegroundColorSelection = new StringSelection("Delta f\u00fcr die Modifikation von Vordergrundfarben (zwischen -255 und 0). Je kleiner desto blasser.");
        this.deltaForBackgroundColorSelection = new StringSelection("Delta f\u00fcr die Modifikation von Hintergrundfarben (zwischen 0 und 255). Je gr\u00f6\u00dfer desto blasser.");
    }

    public void initWithOptions(Options options) {
        this.deltaForForegroundColor = options.getDeltaForForegroundColor();
        this.deltaForBackgroundColor = options.getDeltaForBackgroundColor();
        this.deltaForForegroundColorSelection.setText(Integer.toString(this.deltaForForegroundColor));
        this.deltaForBackgroundColorSelection.setText(Integer.toString(this.deltaForBackgroundColor));
        this.multiplicativeColorModificationCheckBox.setSelected(ColorModificationType.MULTIPLICATIVE == options.getColorModificationType());
        this.initWithColors(options.getColors());
    }

    private void initWithColors(List<Color> list) {
        this.initColorUis(list);
        this.buildPanel();
        this.panel.validate();
        this.panel.invalidate();
        this.panel.repaint();
    }

    private void initColorUis(List<Color> list) {
        if (list.size() != 11) {
            throw new RuntimeException("Es gibt nicht wie erwartet 11 Farben, sondern " + list.size() + ".");
        }
        this.colorUis = new ArrayList<OneOfElevenColorUi>();
        int n = 0;
        for (Color color : list) {
            String string = n + " / 10 richtig beantworete Abfragen";
            ++n;
            OneOfElevenColorUi oneOfElevenColorUi = new OneOfElevenColorUi(string, color, this.vocableColors);
            this.colorUis.add(oneOfElevenColorUi);
        }
    }

    private void buildPanel() {
        this.panel.removeAll();
        this.panel.setLayout(new BorderLayout());
        this.panel.add(this.createColorOptionsPart(), "North");
        this.panel.add(this.createColorsPart(), "Center");
        this.panel.add(this.createButtonPart(), "South");
    }

    private Component createColorOptionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createExplanationButton());
        jPanel.add(this.deltaForForegroundColorSelection.getPanel());
        jPanel.add(this.deltaForBackgroundColorSelection.getPanel());
        jPanel.add(this.multiplicativeColorModificationCheckBox);
        return jPanel;
    }

    private Component createExplanationButton() {
        JButton jButton = new JButton("Erkl\u00e4rung zu den Farben und Modifikationen anzeigen");
        jButton.addActionListener(actionEvent -> this.showColorsAndModificationsExplanation());
        return jButton;
    }

    private void showColorsAndModificationsExplanation() {
        GuiTools.informUser("Erkl\u00e4rung zu den Farben und ihren Modifikationen", COLOR_MODIFICATION_EXPLANATION);
    }

    private Component createColorsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(5, 3));
        for (OneOfElevenColorUi oneOfElevenColorUi : this.colorUis) {
            jPanel.add(oneOfElevenColorUi.getPanel());
        }
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createSetToSubduedColorsButton());
        jPanel.add(this.createSetToIntenseColorsButton());
        return jPanel;
    }

    private Component createSetToSubduedColorsButton() {
        JButton jButton = new JButton("Farben auf ged\u00e4mpftere Werte setzen");
        jButton.addActionListener(actionEvent -> this.setToSubduedColors());
        return jButton;
    }

    private void setToSubduedColors() {
        this.initWithColors(DefaultColors.SUBDUED_COLORS);
    }

    private Component createSetToIntenseColorsButton() {
        JButton jButton = new JButton("Farben auf die intensive Werte setzen");
        jButton.addActionListener(actionEvent -> this.setToIntenseColors());
        return jButton;
    }

    private void setToIntenseColors() {
        this.initWithColors(DefaultColors.INTENSIVE_COLORS);
    }

    public List<Color> getColors() {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (OneOfElevenColorUi oneOfElevenColorUi : this.colorUis) {
            Color color = oneOfElevenColorUi.getColor();
            arrayList.add(color);
        }
        return arrayList;
    }

    public int getDeltaForForegroundColor() {
        String string = this.deltaForForegroundColorSelection.getTrimmedText();
        int n = NumberString.parseIntIgnore(string, this.deltaForForegroundColor);
        if (n > 0 || n < -255) {
            return this.deltaForForegroundColor;
        }
        return n;
    }

    public int getDeltaForBackgroundColor() {
        String string = this.deltaForBackgroundColorSelection.getTrimmedText();
        int n = NumberString.parseIntIgnore(string, this.deltaForBackgroundColor);
        if (n < 0 || n > 255) {
            return this.deltaForBackgroundColor;
        }
        return n;
    }

    public ColorModificationType getColorModificationType() {
        if (this.multiplicativeColorModificationCheckBox.isSelected()) {
            return ColorModificationType.MULTIPLICATIVE;
        }
        return ColorModificationType.ADDITIVE;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setIntoOptions(Options options) {
        options.setColors(this.getColors());
        options.setDeltaForForegroundColor(this.getDeltaForForegroundColor());
        options.setDeltaForBackgroundColor(this.getDeltaForBackgroundColor());
        options.setColorModificationType(this.getColorModificationType());
    }
}

