/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.text.Text;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.TextAreaSelection;
import de.duehl.swing.ui.components.selections.tools.SelectionsHelper;
import de.duehl.swing.ui.dialogs.base.AbstractDialogBase;
import de.duehl.swing.ui.key.BindKeysOnRootPane;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.components.VocableViewer;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.detail.KanjiDetailDialog;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.addtolist.VocableToOwnListAdderGui;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.findlists.ListsWithVocableFinderGui;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.related.VerbsAndAdjectivesFinderGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

class VocableWithInternaPanel {
    static final Dimension DIALOG_DIMENSION = new Dimension(1000, 900);
    private final AbstractDialogBase usingComponent;
    private final Vocable vocable;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final InternalAdditionalVocableData data;
    private final JPanel panel;
    private final ListsWithVocableFinderGui listsWithVocableFinderGui;
    private final VocableToOwnListAdderGui vocableToOwnListAdderGui;
    private final VerbsAndAdjectivesFinderGui verbsAndAdjectivesFinderGui;
    private List<Kanji> kanjiInVocable;

    public VocableWithInternaPanel(AbstractDialogBase abstractDialogBase, Vocable vocable, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Component component, LongTimeProcessInformer longTimeProcessInformer) {
        this.usingComponent = abstractDialogBase;
        this.vocable = vocable;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.listsWithVocableFinderGui = new ListsWithVocableFinderGui(vocable, fumikoDataStructures, component);
        this.vocableToOwnListAdderGui = new VocableToOwnListAdderGui(vocable, fumikoDataStructures, fumikoUiObjects, abstractDialogBase.getLocation());
        this.verbsAndAdjectivesFinderGui = new VerbsAndAdjectivesFinderGui(vocable, fumikoDataStructures, fumikoUiObjects, abstractDialogBase.getLocation(), longTimeProcessInformer);
        InternalDataRequester internalDataRequester = fumikoDataStructures.getInternalDataRequester();
        this.data = internalDataRequester.getInternalDataForVocable(vocable);
        this.panel = new JPanel();
        this.init();
        this.fillPanel();
    }

    private void init() {
        this.determineKanjiInVocable();
    }

    private void determineKanjiInVocable() {
        this.kanjiInVocable = new ArrayList<Kanji>();
        this.kanjiInVocable.addAll(Kanji.getAllKanjiFromText(this.vocable.getKanji()));
        this.kanjiInVocable.addAll(Kanji.getAllKanjiFromText(this.vocable.getComment()));
        CollectionsHelper.makeListDisjunct(this.kanjiInVocable);
    }

    private void fillPanel() {
        this.panel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = GuiTools.createScrollPane(this.createMainPanel());
        this.panel.add((Component)jScrollPane, "Center");
        this.panel.add(this.createLowerPart(), "South");
        GuiTools.scrollScrollbarToMinimumLater(jScrollPane);
        this.keybindingsForPlaySound();
    }

    private Component createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createVocableViewerPart(), "North");
        jPanel.add(this.createVocableAndInternalDataSectionPart(), "Center");
        return jPanel;
    }

    private Component createVocableViewerPart() {
        Options options = this.dataStructures.getOptions();
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        VocableViewer vocableViewer = new VocableViewer(options);
        vocableViewer.showAllTranslationsForUseInDetailsDialog();
        vocableViewer.showVocable(this.vocable, internalDataRequester.getInternalDataForVocable(this.vocable));
        return vocableViewer.getPanel();
    }

    private Component createVocableAndInternalDataSectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createKanaPart());
        jPanel.add(this.createKanjiPart());
        jPanel.add(this.createRomajiPart());
        jPanel.add(this.createPronunciationPart());
        jPanel.add(this.createTranslationsPart());
        jPanel.add(this.createCommentPart());
        jPanel.add(this.createSearchWordsPart());
        jPanel.add(this.createPartsOfSpeechPart());
        jPanel.add(this.createVocabularyDescriptionPart());
        jPanel.add(this.createFirstSeenDatePart());
        jPanel.add(this.createJapaneseToGermanTestCountPart());
        jPanel.add(this.createCorrectJapaneseToGermanTestCountPart());
        jPanel.add(this.createLastJapaneseToGermanTestDatePart());
        jPanel.add(this.createLastCorrectJapaneseToGermanTestDatePart());
        jPanel.add(this.createLastTenJapaneseToGermanTestResultsPart());
        jPanel.add(this.createGermanToJapaneseTestCountPart());
        jPanel.add(this.createCorrectGermanToJapaneseTestCountPart());
        jPanel.add(this.createLastGermanToJapaneseTestDatePart());
        jPanel.add(this.createLastCorrectGermanToJapaneseTestDatePart());
        jPanel.add(this.createLastTenGermanToJapaneseTestResultsPart());
        return jPanel;
    }

    private Component createKanaPart() {
        return this.createSingleStringPart("Kana", this.vocable.getKana());
    }

    private Component createKanjiPart() {
        return this.createSingleStringPart("Kanji", this.vocable.getKanji());
    }

    private Component createRomajiPart() {
        return this.createSingleStringPart("Romaji", this.vocable.getRomaji());
    }

    private Component createPronunciationPart() {
        return this.createSingleStringPart("Aussprache", this.vocable.getPronunciation());
    }

    private Component createTranslationsPart() {
        List<String> list = this.vocable.getTranslations();
        return this.createListPart("\u00dcbersetzung", "\u00dcbersetzungen", list);
    }

    private Component createCommentPart() {
        return this.createSingleLongStringPart("Kommentar", this.vocable.getComment());
    }

    private Component createSearchWordsPart() {
        List<String> list = this.vocable.getSearchWords();
        return this.createListPart("Suchbegriff", "Suchbegriffe", list);
    }

    private Component createPartsOfSpeechPart() {
        List<String> list = this.vocable.getPartsOfSpeech();
        return this.createListPart("Wortart", "Wortarten", list);
    }

    private Component createVocabularyDescriptionPart() {
        return this.createSingleStringPart("Beschreibung des Vokabulars", this.vocable.getVocabularyDescription());
    }

    private Component createFirstSeenDatePart() {
        return this.createDatePart("Zuerst gesehen am", this.data.getFirstSeenDate());
    }

    private Component createJapaneseToGermanTestCountPart() {
        return this.createIntPart("Anzahl der \u00dcbersetzungen Japanisch - Deutsch", this.data.getJapaneseToGermanTestCount());
    }

    private Component createCorrectJapaneseToGermanTestCountPart() {
        return this.createIntPart("Anzahl der richtigen \u00dcbersetzungen Japanisch - Deutsch", this.data.getCorrectJapaneseToGermanTestCount());
    }

    private Component createLastJapaneseToGermanTestDatePart() {
        return this.createDatePart("Zuletzt abgefragt Japanisch - Deutsch", this.data.getLastJapaneseToGermanTestDate());
    }

    private Component createLastCorrectJapaneseToGermanTestDatePart() {
        return this.createDatePart("Zuletzt abgefragt und richtig beantwortet Japanisch - Deutsch", this.data.getLastCorrectJapaneseToGermanTestDate());
    }

    private Component createLastTenJapaneseToGermanTestResultsPart() {
        return this.createSingleStringPart("Erfolg der letzten 10 Abfragen Japanisch - Deutsch", this.data.getLastTenJapaneseToGermanTestResultsAsStorageString());
    }

    private Component createGermanToJapaneseTestCountPart() {
        return this.createIntPart("Anzahl der \u00dcbersetzungen Deutsch - Japanisch", this.data.getGermanToJapaneseTestCount());
    }

    private Component createCorrectGermanToJapaneseTestCountPart() {
        return this.createIntPart("Anzahl der richtigen \u00dcbersetzungen Deutsch - Japanisch", this.data.getCorrectGermanToJapaneseTestCount());
    }

    private Component createLastGermanToJapaneseTestDatePart() {
        return this.createDatePart("Zuletzt abgefragt Deutsch - Japanisch", this.data.getLastGermanToJapaneseTestDate());
    }

    private Component createLastCorrectGermanToJapaneseTestDatePart() {
        return this.createDatePart("Zuletzt abgefragt und richtig beantwortet Deutsch - Japanisch", this.data.getLastCorrectGermanToJapaneseTestDate());
    }

    private Component createLastTenGermanToJapaneseTestResultsPart() {
        return this.createSingleStringPart("Erfolg der letzten 10 Abfragen Deutsch - Japanisch", this.data.getLastTenGermanToJapaneseTestResultsAsStorageString());
    }

    private Component createSingleStringPart(String string, String string2) {
        StringSelection stringSelection = new StringSelection(string);
        SelectionsHelper.initSelectionAsViewer(stringSelection);
        stringSelection.setFocusable(true);
        stringSelection.setText(string2);
        return stringSelection.getPanel();
    }

    private Component createSingleLongStringPart(String string, String string2) {
        String string3 = Text.addLineBreaks(string2, 60);
        List<String> list = Text.splitByLineBreaks(string3);
        int n = list.size();
        if (n == 1) {
            return this.createSingleStringPart(string, list.get(0));
        }
        TextAreaSelection textAreaSelection = new TextAreaSelection(string);
        SelectionsHelper.initSelectionAsViewer(textAreaSelection);
        textAreaSelection.setFocusable(true);
        textAreaSelection.setText(string3);
        textAreaSelection.setRows(n);
        return textAreaSelection.getPanel();
    }

    private Component createListPart(String string, String string2, List<String> list) {
        if (list.size() == 1) {
            return this.createSingleStringPart(string, list.get(0));
        }
        TextAreaSelection textAreaSelection = new TextAreaSelection(string2);
        SelectionsHelper.initSelectionAsViewer(textAreaSelection);
        textAreaSelection.setFocusable(true);
        textAreaSelection.setText(Text.joinWithLineBreak(list));
        return textAreaSelection.getPanel();
    }

    private Component createDatePart(String string, ImmutualDate immutualDate) {
        String string2 = immutualDate.equals(InternalAdditionalVocableData.NOT_SEEN_DATE) ? "" : immutualDate.toString();
        return this.createSingleStringPart(string, string2);
    }

    private Component createIntPart(String string, int n) {
        return this.createSingleStringPart(string, Integer.toString(n));
    }

    private Component createLowerPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        if (!this.kanjiInVocable.isEmpty()) {
            jPanel.add(this.createKanjiButtonsPart());
        }
        this.listsWithVocableFinderGui.appendButtonToPanel(jPanel);
        this.vocableToOwnListAdderGui.appendButtonToPanel(jPanel);
        this.verbsAndAdjectivesFinderGui.appendButtonsToPanel(jPanel);
        jPanel.add(this.createButtonsPart());
        return jPanel;
    }

    private Component createKanjiButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 0, 0));
        for (JButton jButton : this.createKanjiButtons()) {
            jPanel.add(jButton);
        }
        return jPanel;
    }

    private List<JButton> createKanjiButtons() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        for (Kanji kanji : this.kanjiInVocable) {
            JButton jButton = this.createKanjiButton(kanji);
            arrayList.add(jButton);
        }
        return arrayList;
    }

    private JButton createKanjiButton(Kanji kanji) {
        JButton jButton = new JButton(kanji.getCharacter());
        jButton.addActionListener(actionEvent -> this.showKanji(kanji));
        return jButton;
    }

    private void showKanji(Kanji kanji) {
        KanjiDetailDialog kanjiDetailDialog = new KanjiDetailDialog(kanji, this.dataStructures, this.uiObjects, this.usingComponent, this.usingComponent.getLocation());
        kanjiDetailDialog.setVisible(true);
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createPlaySoundKeyCombinationLabel(), "West");
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createPlaySoundKeyCombinationLabel() {
        JLabel jLabel = new JLabel("Abspielen mit F9");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return jLabel;
    }

    private void keybindingsForPlaySound() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(120, 0);
        String string = "F9";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.playMp3());
        JRootPane jRootPane = this.usingComponent.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private void playMp3() {
        String string = this.vocable.getMp3();
        VocabularyTools.playMp3(string);
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.usingComponent.closeDialog();
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

