/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.findlists;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.text.TextViewer;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import java.awt.Component;
import java.util.List;

class ListsWithVocableFinder {
    private final FumikoDataStructures dataStructures;
    private final Component thisPanelUsingDialog;

    public ListsWithVocableFinder(FumikoDataStructures fumikoDataStructures, Component component) {
        this.dataStructures = fumikoDataStructures;
        this.thisPanelUsingDialog = component;
    }

    public void findListsWithVocable(Vocable vocable) {
        String string = vocable.getKanji();
        String string2 = vocable.getKana();
        String string3 = string.isBlank() ? string2 : string + " (" + string2 + ")";
        OwnLists ownLists = this.dataStructures.getOwnLists();
        List<String> list = ownLists.findNamesOfListsWithVocable(vocable);
        if (list.isEmpty()) {
            GuiTools.informUser(this.thisPanelUsingDialog, "Keine Liste gefunden.", string3 + "\n\nDie Vokabel kommt in keiner Liste vor.");
        } else {
            String string4 = "Die Vokabel " + string3 + " kommt in den folgenden Listen vor:\n\n" + Text.joinWithLineBreak(list);
            TextViewer textViewer = new TextViewer("Listen mit der Vokabel", this.thisPanelUsingDialog.getLocation());
            textViewer.setText(string4);
            textViewer.setVisible(true);
        }
    }
}

