/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.related;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.grammar.AdjectivePositivePresenceFinder;
import de.duehl.vocabulary.japanese.grammar.VerbWoerterbuchformFinder;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.related.VerbAndAdjectiveButtonsCreator;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.related.VerbsAndAdjectivesFinder;
import java.awt.Point;
import javax.swing.JPanel;

public class VerbsAndAdjectivesFinderGui {
    private final Vocable vocable;
    private final FumikoDataStructures dataStructures;
    private final VerbsAndAdjectivesFinder verbsAndAdjectivesFinder;
    private final VerbAndAdjectiveButtonsCreator creator;

    public VerbsAndAdjectivesFinderGui(Vocable vocable, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point, LongTimeProcessInformer longTimeProcessInformer) {
        this.vocable = vocable;
        this.dataStructures = fumikoDataStructures;
        this.verbsAndAdjectivesFinder = new VerbsAndAdjectivesFinder(fumikoDataStructures, fumikoUiObjects, point, longTimeProcessInformer);
        this.creator = new VerbAndAdjectiveButtonsCreator(vocable, this.verbsAndAdjectivesFinder);
    }

    public void appendButtonsToPanel(JPanel jPanel) {
        Vocable vocable;
        if (this.vocable.isVerbInWoerterbuchform()) {
            jPanel.add(this.creator.createFindRelatedVerbsButton());
        } else if (this.vocable.isVerb() && !(vocable = VerbWoerterbuchformFinder.determineWoerterbuchform(this.vocable, this.dataStructures.getVocabularies())).equals(VerbWoerterbuchformFinder.NO_WOERTERBUCHFORM_FOUND)) {
            jPanel.add(this.creator.createFindRelatedVerbsButtonViaWoerterbuchform(vocable));
        }
        if (this.vocable.isAdjectivInPositivePresence()) {
            jPanel.add(this.creator.createFindRelatedAdjectiveButton());
        } else if (this.vocable.isAdjective() && !(vocable = AdjectivePositivePresenceFinder.determinePositivePresence(this.vocable, this.dataStructures.getVocabularies())).equals(AdjectivePositivePresenceFinder.NO_POSITIVE_PRESENCE_FOUND)) {
            jPanel.add(this.creator.createFindRelatedAdjectiveButtonViaPositivePresence(vocable));
        }
    }
}

