package de.duehl.basics.autodetect.ent;

import de.duehl.basics.text.Text;

/**
 * Diese Klasse ist die abstrakte Basis einer Klasse, Kommentare zur automatischen Bearbeitung
 * hinzufügt.
 *
 * @version 1.01     2022-07-26
 * @author Christian Dühl
 */

public abstract class AutoCommentAppender {

    /**
     * Hier entstehen die Kommentare zur automatischen Vergabe, sie werden später denen der
     * automatischen Bearbeitung hinzugefügt.
     */
    private final StringBuilder autoComment;

    /** Konstruktor. */
    public AutoCommentAppender() {
        autoComment = new StringBuilder();
    }

    /** Fügt etwas an den sich aufbauenden Kommentar zur automatischen Bearbeitung an. */
    protected final void appendAutoComment(String appendix) {
        autoComment.append(" ").append(appendix);
    }

    /** Gibt den Inhalt des Auto-Kommentars zurück. */
    public final String getAutoComment() {
        return Text.stripWhitespace(autoComment.toString());
    }

    /** Legt den Inhalt des Auto-Kommentars fest. */
    public final void setAutoComment(String autoComment) {
        this.autoComment.setLength(0);
        this.autoComment.append(autoComment);
    }

}
