package de.duehl.basics.datetime;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse hält einen Timestamp in Standardform vor und kann ihn in Menschenlesbarer Form
 * ausgeben. Dies ist auch bei toString() der Fall.
 *
 * @version 1.01     2017-03-10
 * @author Christian Dühl
 */

public class TimestampBeautified {

    private final String timestamp;

    private final String beautifiedTimestamp;

    public TimestampBeautified(String timestamp) {
        this.timestamp = timestamp;
        beautifiedTimestamp = Timestamp.beautifyTimestamp(timestamp);
    }

    public String getTimestamp() {
        return timestamp;
    }

    public String getBeautifiedTimestamp() {
        return beautifiedTimestamp;
    }

    @Override
    public String toString() {
        return beautifiedTimestamp;
    }

}
