package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.regex.Pattern;

import de.duehl.basics.datetime.date.ImmutualDate;

/**
 * Diese Klasse stellt die Methode zum Parsen des Standardfalls eines Datums aus einem String
 * dar.
 *
 * Erkannt werden:
 *     - 2013-08-22
 *     - 2013-8-22
 *     - 2013-8-2
 *     - 2013-12-6
 *
 * @version 1.01     2021-03-19
 * @author Christian Dühl
 */

public class DateParseMethodMinus extends DateParseMethod {

    private final static Pattern PATTERN = Pattern.compile(
            "(\\d{4})-(\\d{1,2})-(\\d{1,2})");

    public DateParseMethodMinus(String dateToParse) {
        super(dateToParse, PATTERN);
    }

    @Override
    protected ImmutualDate createDateFromMatcher() {
        int day   = Integer.parseInt(matcher.group(3));
        int month = Integer.parseInt(matcher.group(2));
        int year  = Integer.parseInt(matcher.group(1));

        return new ImmutualDate(day, month, year);
    }

}
