package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.regex.Pattern;

import de.duehl.basics.datetime.date.ImmutualDate;

/**
 * Diese Klasse stellt die Methode zum Parsen eines Datums von Unix (dow mon dd hh:mm:ss zzz yyyy)
 * aus einem String dar.
 *
 * Erkannt werden:
 *     - Wed Jan 18 12:01:50 CET 2012
 *
 * @version 1.01     2018-11-16
 * @author Christian Dühl
 */

public class DateParseMethodUnix extends DateParseMethod {

    private final static Pattern PATTERN = Pattern.compile(
            "\\w+ (\\w+) (\\d+) \\d{2}:\\d{2}:\\d{2} \\w+ (\\d{4})");

    public DateParseMethodUnix(String dateToParse) {
        super(dateToParse, PATTERN);
    }

    @Override
    protected ImmutualDate createDateFromMatcher() {
        int day   = Integer.parseInt(matcher.group(2));
        int month = translateMonthFromStringToInt(matcher.group(1));
        int year  = Integer.parseInt(matcher.group(3));

        return new ImmutualDate(day, month, year);
    }

}
