package de.duehl.basics.io;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt ein Suchergebnis dar.
 *
 * @version 1.01     2013-12-12
 * @author Christian Dühl
 */

public class FileSearchResult {

    /** Name der Datei (mit Pfad). */
    private final String file;

    /** Zeilennummer der Fundstelle. */
    private final int lineNumber;

    /** Zeile mit der Fundstelle. */
    private final String searchedLine;

    /**
     * Konstruktor.
     *
     * @param file
     *            Name der Datei (mit Pfad).
     * @param lineNumber
     *            Zeilennummer der Fundstelle.
     * @param searchedLine
     *            Zeile mit der Fundstelle.
     */
    public FileSearchResult(final String file, final int lineNumber,
            final String searchedLine) {
        this.file = file;
        this.lineNumber = lineNumber;
        this.searchedLine = searchedLine;
    }

    /** Getter für den Namen der Datei (mit Pfad). */
    public String getFile() {
        return file;
    }

    /** Getter für die Zeilennummer der Fundstelle. */
    public int getLineNumber() {
        return lineNumber;
    }

    /** Getter für die Zeile mit der Fundstelle. */
    public String getSearchedLine() {
        return searchedLine;
    }

    /** Stringrepräsentation. */
    @Override
    public String toString() {
        return "FileSearchResult [file=" + file + ", lineNumber=" + lineNumber
                + ", searchedLine=" + searchedLine + "]";
    }

}
