package de.duehl.basics.io.data;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.FileHelper;

/**
 * Diese Klasse stellt eine Datei mit dem Datum ihrer letzten Veränderung dar.
 *
 * @version 1.01     2019-01-18
 * @author Christian Dühl
 */

public class FileWithModificationTime {

    /** Name der Datei mit Pfad. */
    private final String filename;

    /** Letzter Zeitpunkt der Modifikation der Datei im Timestamp-Format YYYYMMDD_HHMMSS. */
    private final String modificationTime;

    public FileWithModificationTime(String filename) {
        this.filename = filename;
        modificationTime = FileHelper.fileLastModified(filename);
    }

    public String getFilename() {
        return filename;
    }

    public String getModificationTime() {
        return modificationTime;
    }

    @Override
    public String toString() {
        return "FileWithModificationTime [filename=" + filename + ", modificationTime="
                + modificationTime + "]";
    }

}
