package de.duehl.basics.io.data;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse steht für eine Zeile mit ihrer Zeilennummer.
 *
 * @version 1.01     2024-10-22
 * @author Christian Dühl
 */

public class LineWithNumber {

    /** Die Zeile. */
    private final String line;

    /** Die Zeilennummer. */
    private final int lineNumber;

    /**
     * Konstruktor.
     *
     * @param line
     *            Die Zeile.
     * @param lineNumber
     *            Die Zeilennummer.
     */
    public LineWithNumber(String line, int lineNumber) {
        this.line = line;
        this.lineNumber = lineNumber;
    }

    /** Getter für die Zeile. */
    public String getLine() {
        return line;
    }

    /** Getter für die Zeilennummer. */
    public int getLineNumber() {
        return lineNumber;
    }

    @Override
    public String toString() {
        return "LineWithNumber [line=" + line + ", lineNumber=" + lineNumber + "]";
    }

}
