package de.duehl.basics.io.textfile.data;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt eine Definition bestehend aus Schlüssel und Wert dar.
 *
 * @version 1.01     2021-03-01
 * @author Christian Dühl
 */

public class Definition {

    /** Der Schlüssel der Definition. */
    private final String key;

    /** Der Wert der Definition. */
    private final String value;

    /**
     * Konstruktor.
     *
     * @param key
     *            Der Schlüssel der Definition
     * @param value
     *            Der Wert der Definition.
     */
    public Definition(String key, String value) {
        this.key = key;
        this.value = value;
    }

    /** Getter für den Schlüssel der Definition. */
    public String getKey() {
        return key;
    }

    /** Getter für den Wert der Definition. */
    public String getValue() {
        return value;
    }

    /** Gibt an, ob beide Definitionen den gleichen Schlüssel haben. */
    public boolean hasSameKey(Definition that) {
        return this.key.equals(that.key);
    }

    @Override
    public String toString() {
        return key + " = " + value;
        //return "Definition [key=" + key + ", value=" + value + "]";
    }

}
