package de.duehl.basics.logic;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.Objects;

/**
 * Diese Klasse stellt ein Paar für zwei Objekte vom gleichen Typ dar.
 *
 * @version 1.01     2022-07-13
 * @author Christian Dühl
 */

public class Pair<T> {

    /** Erstes Objekt. */
    private final T first;

    /** Zweites Objekt. */
    private final T second;

    /**
     * Konstruktor.
     *
     * @param first
     *            Erstes Objekt.
     * @param second
     *            Zweites Objekt.
     */
    public Pair(T first, T second) {
        this.first = first;
        this.second = second;
    }

    /** Getter für das erste Objekt. */
    public T getFirst() {
        return first;
    }

    /** Getter für das zweite Objekt. */
    public T getSecond() {
        return second;
    }

    @Override
    public String toString() {
        return "Pair [first=" + first + ", second=" + second + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(first, second);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Pair<?> other = (Pair<?>) obj;
        return Objects.equals(first, other.first) && Objects.equals(second, other.second);
    }

}
