package de.duehl.basics.text;

/*
 * Copyright 2023 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;

/**
 * Diese Klasse stellt eine Menge von Datenfeldern dar, die zum Beispiel aus einer Zeile einer
 * tabgetrennten Datei eingelesen wurden.
 *
 * Da es inhaltlich eine Sammlung von Strings ist, genau wie die Zeilen, wird unter der Haube Lines
 * verwendet, um dem DRY-Prinzip zu entsprechen.
 *
 * @version 1.01     2023-02-27
 * @author Christian Dühl
 */

public class Fields extends Lines {

    /** Konstruktor mit leerer Menge an Feldern. */
    public Fields() {
        super();
    }

    /**
     * Konstruktor der die übergebene Liste von Feldern übernimmt.
     *
     * @param fields
     *            Eine Liste mit Feldern.
     */
    public Fields(List<String> fields) {
        super(fields);
    }

    /**
     * Konstruktor der die übergebene Liste von Feldern übernimmt.
     *
     * @param fields
     *            Eine Liste mit Feldern.
     */
    public Fields(String ... fields) {
        super(CollectionsHelper.arrayToList(fields));
    }

    /**
     * Konstruktor der das übergebene Objekt von Feldern übernimmt.
     *
     * @param fields
     *            Objekt mit Feldern.
     */
    public Fields(Fields fields) {
        super(fields);
    }

    /**
     * Stellt die Felder schön dar. Mit Indices beginnend bei 1 und in eckigen Klammern eingefasst.
     */
    public String listListNice() {
        return CollectionsHelper.listListNice(getLines());
    }

    /** Gibt die Felder als Liste von Strings zurück. */
    public List<String> getFields() {
        return getLines();
    }

    /** Macht aus einer Reihe von Strings ein Fields-Objekt. */
    public static Fields buildListFrom(String ... fields) {
        return new Fields(CollectionsHelper.buildListFrom(fields));
    }

}
