package de.duehl.basics.text.data;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.Charset;

/**
 * Diese Klasse stellt Informationen zu einer Textdatei dar.
 *
 * Es liegt der Dateiname, das Encoding und die Information vor, ob die Datei eine Titelzeile enthält.
 *
 * @version 1.01     2024-08-01
 * @author Christian Dühl
 */

public class TextFileInformation {

    /** Der Dateiname. */
    private final String filename;

    /** Das Encoding. */
    private final Charset charset;

    /** Gibt an ob die Datei eine Titelzeile enthält. */
    private final boolean hasTitleRow;

    /**
     * Konstruktor für eine Datei mit Titelzeile.
     *
     * @param filename
     *            Der Dateiname.
     * @param charset
     *            Das Encoding.
     */
    public TextFileInformation(String filename, Charset charset) {
        this(filename, charset, true);
    }

    /**
     * Konstruktor.
     *
     * @param filename
     *            Der Dateiname.
     * @param charset
     *            Das Encoding.
     * @param hasTitleRow
     *            Gibt an ob die Datei eine Titelzeile enthält.
     */
    public TextFileInformation(String filename, Charset charset, boolean hasTitleRow) {
        this.filename = filename;
        this.charset = charset;
        this.hasTitleRow = hasTitleRow;
    }

    /** Getter für den Dateinamen. */
    public String getFilename() {
        return filename;
    }

    /** Getter für das Encoding. */
    public Charset getCharset() {
        return charset;
    }

    /** Gibt an ob die Datei eine Titelzeile enthält. */
    public boolean isHasTitleRow() {
        return hasTitleRow;
    }

    @Override
    public String toString() {
        return "TextFileInformation [filename=" + filename + ", charset=" + charset
                + ", hasTitleRow=" + hasTitleRow + "]";
    }

}
