package de.duehl.basics.text.xml.own;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für eine Daten-Klasse, welche sich persistent als Zeilen in einer
 * XML-Datei abspeichern kann. Da Gegenstück zum Einlesen ist eine statische Methode der Art:
 *
 *     public static TaskSector createFromXmlLine(String line) {
 *         String name = OwnXmlHelper.readContentOfSingleUniqueXmlElementInXmlLine(
 *                 XML_SINGLE_SECTOR_NAME_DATA_IDENTIFIER, line);
 *         TaskSector sector = new TaskSector(name);
 *         return sector;
 *     }
 *
 * @version 1.01     2021-11-09
 * @author Christian Dühl
 */

public interface XmlStorable {

    /** Erzeugt eine Darstellung im XML. */
    String toXml();

}
