package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.datetime.date.ImmutualDate;

public class DateParseMethodYYYYMMDDTest {

    @Test
    public void parse() {
        DateParseMethod method = new DateParseMethodYYYYMMDD("20130822");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(22, date.getDay());
        assertEquals(8, date.getMonth());
        assertEquals(2013, date.getYear());

        assertTrue(date.isValid());
    }

}
