package de.duehl.basics.io.textfile;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.textfile.data.Definitions;

public class DefinitionsFromTextFileInJarReaderTest {

    @Test
    public void read() {
        Class<?> clazz = this.getClass();
        DefinitionsFromTextFileReader reader = new DefinitionsFromTextFileInJarReader(
                "DefinitionsTestFile.txt", Charset.UTF_8, clazz, "#");
        reader.beQuiet();
        Definitions definitions = reader.read();

        assertEquals(4, definitions.size());

        assertTrue(definitions.containsKey("a"));
        assertTrue(definitions.containsKey("b"));
        assertTrue(definitions.containsKey("c"));
        assertTrue(definitions.containsKey("modus"));

        assertEquals("eins", definitions.getValueByKey("a"));
        assertEquals("zwei", definitions.getValueByKey("b"));
        assertEquals("drei", definitions.getValueByKey("c"));
        assertEquals("komisch", definitions.getValueByKey("modus"));
    }


}
