package de.duehl.basics.io.textfile;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.io.File;
import java.util.List;

import org.junit.Test;

import de.duehl.basics.io.Charset;
import de.duehl.basics.test.TestHelper;

public class HeaderAndDataFromTabSeparatedFileReaderTest {

    private final String path;

    public HeaderAndDataFromTabSeparatedFileReaderTest() {
        TestHelper testHelper = TestHelper.createForBasics(getClass(), 7);
        path =  testHelper.getTestDataPath() + File.separator;
    }


    /* -------------------------- TESTS -------------------------- */


    @Test
    public void readTestFile() {
        String filename = path + "tab_separated_testfile.txt";
        HeaderAndDataFromTabSeparatedFileReader reader =
                new HeaderAndDataFromTabSeparatedFileReader(filename, Charset.UTF_8);
        reader.readAndCheck();

        List<String> titles = reader.getTitles();

        assertEquals(7, titles.size());
        assertEquals("ID", titles.get(0));
        assertEquals("Name", titles.get(1));
        assertEquals("Straße", titles.get(2));
        assertEquals("Postleitzahl", titles.get(3));
        assertEquals("Ort", titles.get(4));
        assertEquals("Geburtstag", titles.get(5));
        assertEquals("Lieblingsfarbe", titles.get(6));

        List<List<String>> listOfDataSets = reader.getListOfDataSets();

        assertEquals(3, listOfDataSets.size());
        assertEquals(3, reader.getSizeOfDataLines());
        List<String> dataSets = listOfDataSets.get(1);
        assertEquals("2", dataSets.get(0));
        assertEquals("Anna Mustermann", dataSets.get(1));
        assertEquals("Musterstraße 1", dataSets.get(2));
        assertEquals("12345", dataSets.get(3));
        assertEquals("Musterhausen", dataSets.get(4));
        assertEquals("30.11.1989", dataSets.get(5));
        assertEquals("Türkis", dataSets.get(6));
    }

}
