package de.duehl.basics.io.textfile;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.junit.Test;

import de.duehl.basics.io.Charset;

public class ListsFromTextFileInJarReaderTest {

    @Test
    public void read() {
        Class<?> clazz = this.getClass();
        ListsFromTextFileReader reader = new ListsFromTextFileInJarReader("list_test_datei.txt",
                Charset.UTF_8, clazz, "#");
        reader.beQuiet();
        List<List<String>> listOfLists = reader.read();
        assertEquals(3, listOfLists.size());

        List<String> list1 = listOfLists.get(0);
        List<String> list2 = listOfLists.get(1);
        List<String> list3 = listOfLists.get(2);

        assertEquals(3, list1.size());
        assertEquals(2, list2.size());
        assertEquals(1, list3.size());

        assertEquals("eins", list1.get(0));
        assertEquals("eins2", list1.get(1));
        assertEquals("eins3", list1.get(2));
        assertEquals("zwei", list2.get(0));
        assertEquals("zewiii", list2.get(1));
        assertEquals("drei", list3.get(0));
    }


}
