package de.duehl.basics.java;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;

import org.junit.Test;

import de.duehl.basics.collections.CollectionsHelper;

public class JavaThingsTest {

    @Test
    public void breakBreaksOnlyInnerLoop() {
        List<Integer> numbers = new ArrayList<>();

        for (int outer = 1; outer < 5; ++outer) {
            for (int inner = 5; inner < 9; ++inner) {
                numbers.add(outer * 10 + inner);
                if (outer * 2 == inner) {
                    break;
                }
            }
        }

        //System.out.println(numbers);
        assertEquals(CollectionsHelper.buildListFrom(
                15, 16, 17, 18,  // outer = 1
                25, 26, 27, 28,  // outer = 2
                35, 36,          // outer = 3, hier ist 2 * 3 = 6, break nach Hinzufügen
                45, 46, 47, 48), // outer = 4  <- Hier geht die äußere Schleife weiter.
                numbers);
    }

}
