package de.duehl.basics.pictures;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class PictureHelperTest {

    @Test
    public void determinePictureFormatNameJpg() {
        String filename = "C:/bla/foo/Beispiel.jpg";
        String actual = PictureHelper.determinePictureFormatName(filename);
        String expected = "jpg";
        assertEquals(expected, actual);
    }

    @Test
    public void determinePictureFormatNameJpeg() {
        String filename = "C:/bla/foo/Beispiel.jpeg";
        String actual = PictureHelper.determinePictureFormatName(filename);
        String expected = "jpg";
        assertEquals(expected, actual);
    }

    @Test
    public void determinePictureFormatNameJpgUpperCase() {
        String filename = "C:/bla/foo/Beispiel.JPG";
        String actual = PictureHelper.determinePictureFormatName(filename);
        String expected = "jpg";
        assertEquals(expected, actual);
    }

    @Test
    public void determinePictureFormatNameJpegUpperCase() {
        String filename = "C:/bla/foo/Beispiel.JPEG";
        String actual = PictureHelper.determinePictureFormatName(filename);
        String expected = "jpg";
        assertEquals(expected, actual);
    }

    @Test
    public void determinePictureFormatNamePgn() {
        String filename = "C:/bla/foo/Beispiel.png";
        String actual = PictureHelper.determinePictureFormatName(filename);
        String expected = "png";
        assertEquals(expected, actual);
    }

}
