package de.duehl.basics.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import de.duehl.basics.logic.BulletinBoardCode;

public class BulletinBoardCodeSwingTest {

    private JFrame frame;

    public BulletinBoardCodeSwingTest() {
        /* Anlegen des Mainframes: */
        frame = new JFrame();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());
        Dimension dimension = new Dimension(600, 450);
        frame.setPreferredSize(dimension);

        /* Mittleren Teil anlegen: */
        frame.add(createCenterPanel(), BorderLayout.CENTER);

        /* Unteren Teil anlegen: */
        frame.add(createLowerPart(), BorderLayout.SOUTH);

        frame.pack();
        frame.setLocation(450, 290);
    }

    private Component createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setFocusable(false);
        editorPane.setContentType("text/html");

        String bbCode = "<html xmlns=\"http://www.w3.org/1999/xhtml\" "
                + "xml:lang=\"de\" lang=\"de\">\n"
                + "<head></head>\n"
                + "<body>\n"
                + "    normal<br/>\n"
                + "    [b]bold[/b]<br/>\n"
                + "    [i]italic[/i]<br/>\n"
                + "    [u]underline[/u]<br/>\n"
                + "    [s]durchgestrichen[/s]<br/>\n"
                + "    etwas [c]proportionales[/c] zwischen anderem<br/>\n"
                + "    [h1]h1[/h1]<br/>\n"
                + "    [h2]h2[/h2]<br/>\n"
                + "    [h3]h3[/h3]<br/>\n"
                + "    [h4]h4[/h4]<br/>\n"
                + "    [h5]h5[/h5]<br/>\n"
                + "    [h6]h6[/h6]<br/>\n"
                + "    [quote]quote[/quote]<br/>\n"
                + "    [p]paragraph1[/p] [p]paragraph2[/p] [p]paragraph3[/p]<br/>\n"
                + "    [center]center[/center]<br/>\n"
                + "    [align=left]align left[/align]<br/>\n"
                + "    [align=center]align center[/align]<br/>\n"
                + "    [align=right]align right[/align]<br/>\n"
                + "    [color=red]color red[/color]<br/>\n"
                + "    [color=blue]color blue[/color]<br/>\n"
                + "    [color=green]color green[/color]<br/>\n"
                + "    [color=maroon]color maroon[/color]<br/>\n"
                + "    [size=1]size 1[/size]<br/>\n"
                + "    [size=2]size 2[/size]<br/>\n"
                + "    [size=3]size 3[/size]<br/>\n"
                + "    [size=4]size 4[/size]<br/>\n"
                + "    [size=5]size 5[/size]<br/>\n"
                + "    [size=6]size 6[/size]<br/>\n"
                + "    [size=7]size 7[/size]<br/>\n"
                + "    [size=8]size 8[/size]<br/>\n"
                + "    [size=9]size 9[/size]<br/>\n"
                + "    [size=10]size 10[/size]<br/>\n"
                + "    [size=11]size 11[/size]<br/>\n"
                + "    [size=12]size 12[/size]<br/>\n"
                + "    [size=13]size 13[/size]<br/>\n"
                + "    [size=14]size 14[/size]<br/>\n"
                + "    [size=15]size 15[/size]<br/>\n"
                + "    [size=16]size 16[/size]<br/>\n"
                + "    [size=17]size 17[/size]<br/>\n"
                + "    [size=18]size 18[/size]<br/>\n"
                + "    [size=24]size 24[/size]<br/>\n"
                + "    [size=36]size 36[/size]<br/>\n"
                + "    [size=48]size 48[/size]<br/>\n"
                //+ "    [img]c:\\Users\\Anwender\\Daten\\java\\workspace\\hup.messenger\\src\\hup\\messenger\\ui\\resources\\hup_messenger.png[/img]<br/>\n"
                //+ "    [img]c:\\Users\\Anwender\\Downloads\\kram\\Edith.jpg[/img]<br/>\n"
                + "    [email]christian.duehl@heinsundpartner.de[/email]<br/>\n"
                + "    [email=christian.duehl@heinsundpartner.de]E-Mail Christian[/email]<br/>\n"
                //+ "    [youtube]blubb[/youtube]<br/>\n"
                //+ "    [video]blubb[/video]<br/>\n"
                + "    Liste normal 1: [list]<br/>\n"
                + "        [*] eins<br/>\n"
                + "        [*] zwei<br/>\n"
                + "    [/list]<br/>\n"
                + "    Liste mit Zahlen: [list=1]<br/>\n"
                + "        [*] eins: 1<br/>\n"
                + "        [*] zwei: 2<br/>\n"
                + "    [/list]<br/>\n"
                + "    Liste mit römischen Buchstaben: [list=i]<br/>\n"
                + "        [*] eins: i<br/>\n"
                + "        [*] zwei: ii<br/>\n"
                + "    [/list]<br/>\n"
                + "    Liste mit Buchstaben: [list=a]<br/>\n"
                + "        [*] eins: a<br/>\n"
                + "        [*] zwei: b<br/>\n"
                + "    [/list]<br/>\n"
                + "    Liste normal 2: [list]<br/>\n"
                + "        [*] eins Nummer 2<br/>\n"
                + "        [*] zwei Nummer 2<br/>\n"
                + "    [/list]<br/>\n"
                + "    Liste normal 3: [list]<br/>\n"
                + "        [*] eins Nummer 3<br/>\n"
                + "        [*] zwei Nummer 3<br/>\n"
                + "    [/list]<br/>\n"
                + "    [pre]irgendwelcher Kram<br/>"
                + "          eins<br/>"
                + "          zwei<br/>"
                + "          drei<br/>"
                + "          vier<br/>"
                + "          fünf<br/>"
                + "    [/pre]<br/>\n"
                + "</body></html>";

        System.out.println(bbCode);
        BulletinBoardCode bbc = new BulletinBoardCode();
        String html = bbc.toHtmlForJava(bbCode);
        editorPane.setText(html);
        System.out.println();
        System.out.println(html);

        panel.add(editorPane, BorderLayout.CENTER);

        JScrollPane scroll = new JScrollPane(panel);
        return scroll;
    }

    private Component createLowerPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        JButton quitButton = new JButton("Abbrechen");
        panel.add(quitButton, BorderLayout.WEST);
        quitButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent arg0) {
                quit();
            }
        });

        JButton okButton = new JButton("OK");
        panel.add(okButton, BorderLayout.EAST);
        okButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent arg0) {
                apply();
            }
        });

        return panel;
    }

    /** Reaktion auf den OK-Button. */
    private void apply() {
        closeDialog();
    }

    /** Beendet den Optionendialog. */
    private void closeDialog() {
        frame.setVisible(false);
        frame.dispose();
    }

    /** Wird beim Beenden aufgerufen, durch [x] oder Abbruch-Button. */
    public void quit() {
        closeDialog();
    }

    /** Setzt die Sichtbarkeit des Dialogs. */
    public void setVisible(boolean onOrOff) {
        frame.setVisible(onOrOff);
    }

    public static void main(String[] args) {
        new BulletinBoardCodeSwingTest().setVisible(true);
    }

}
