package de.duehl.basics.start;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.zip.UnzipWith7Zip;

public class Testing7ZipUnzipping3 {

    public static void main(String[] args) {
        String dir = "c:/temp/zipping_test4";

        String zipFilename = FileHelper.concatPathes(dir, "daten.zip");

        String targetDir = FileHelper.concatPathes(dir, "entpackTestProgramm");
        FileHelper.createDirectoryIfNotExists(targetDir);

        UnzipWith7Zip unzip = new UnzipWith7Zip();
        unzip.cypher("Geheim");
        unzip.unzip(zipFilename, targetDir);
        System.out.println("Ausgeführtes Kommando: " + unzip.getCommand());
    }

}
