package de.duehl.basics.system;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class SytemToolsTest {

    @Test
    public void determineOperationSystem() {
        OperationSystem os = SystemTools.determineOperationSystem();
        assertNotNull(os);
    }

    @Test
    public void determineOperationSystemRunningWindoes() {
        OperationSystem os = SystemTools.determineOperationSystem();
        assertEquals(OperationSystem.WINDOWS, os);
    }

    @Test
    public void getUserName() {
        String user = SystemTools.getUserName();
        assertEquals("usr207", user);
    }

    @Test
    public void getComputerName() {
        String computer = SystemTools.getComputerName();
        assertEquals("PC170", computer); // PC119
    }

    @Test
    public void getHomeDirectory() {
        String computer = SystemTools.getHomeDirectory();
        assertEquals("C:\\Users\\usr207", computer); // "C:\\Users\\setup"
    }

    @Test
    public void getLocalhost() {
        String ip4Address = SystemTools.getLocalhost();
        assertEquals("192.168.30.170", ip4Address); // "192.168.30.119"
    }

    @Test
    public void determineRunningJavaExecutable() {
        String actual = SystemTools.determineRunningJavaExecutable();
        String expected =
                //"C:\\Program Files\\Eclipse Adoptium\\jdk-17.0.1.12-hotspot\\bin\\javaw.exe";
                "C:\\Meine_Programme\\Java_von_Pc119\\jdk-17.0.1.12-hotspot\\bin\\javaw.exe";
        assertEquals(expected, actual);
    }

    @Test
    public void getCurrentWorkingDirectory() {
        String actual = SystemTools.getCurrentWorkingDirectory();
        //String expected = "C:\\Users\\setup\\Daten\\java\\workspace\\de.duehl.basics";
        String expected = "C:\\Users\\usr207\\Daten\\java\\workspace\\de.duehl.basics";
        assertEquals(expected, actual);
    }

    @Test
    public void isPathInProtectedWindowsProgramDirs() {
        String dir = "";
        assertFalse(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsExactly1() {
        String dir = "C:\\Program Files";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsExactly2() {
        String dir = "C:\\Program Files (x86)";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsExactly3() {
        String dir = "C:\\Programme";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsExactly4() {
        String dir = "C:\\Programme (x86)";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsLowerd1() {
        String dir = "c:\\program files";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsLowerd2() {
        String dir = "c:\\program files (x86)";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsLowerd3() {
        String dir = "c:\\programme";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsLowerd4() {
        String dir = "c:\\programme (x86)";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsPartOf1() {
        String dir = "C:\\Program Files/foo.txt";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsPartOf2() {
        String dir = "C:\\Program Files (x86)/bar/foo.txt";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsPartOf3() {
        String dir = "C:\\Programme/bar/baz/foo.txt";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

    @Test
    public void isPathInProtectedWindowsProgramDirsPartOf4() {
        String dir = "C:\\Programme (x86)/bar/baz/blubb/foo.txt";
        assertTrue(SystemTools.isPathInProtectedWindowsProgramDirs(dir));
    }

}
