package de.duehl.basics.test;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.system.OutputStreamSaveAndRelease;

/**
 * Diese Klasse stellt eine Basisklasse für Unit-Tests dar, die mit Ausgaben auf System.out oder
 * System.err fangen oder schlicht nicht anzeigen wollen. In dieser Geschmacksrichtung für statische
 * Methoden.
 *
 * @version 1.01     2016-01-21
 * @author Christian Dühl
 */

public abstract class StaticOutAndErrStreamHandlingTest {

    private static final OutputStreamSaveAndRelease STREAM_SAVE = new OutputStreamSaveAndRelease();

    /** Sichert den originalen Strom System.out und lenkt System.out auf einen neuen um. */
    protected static void saveSystemOut() {
        STREAM_SAVE.saveSystemOut();
    }

    /** Setzt System.out wieder auf den Standard. */
    protected static void releaseSystemOut() {
        STREAM_SAVE.releaseSystemOut();
    }

    /** Sichert den originalen Strom System.err und lenkt System.err auf einen neuen um. */
    protected static void saveSystemErr() {
        STREAM_SAVE.saveSystemErr();
    }

    /** Setzt System.err wieder auf den Standard. */
    protected static void releaseSystemErr() {
        STREAM_SAVE.releaseSystemErr();
    }

}
