package de.duehl.basics.text;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class TextPositionsTest {

    @Test
    public void create() {
        TextPositions positions = new TextPositions();
        assertFalse(null == positions);
    }

    @Test
    public void sort() {
        TextPositions positions = new TextPositions();
        TextPosition pos1 = new TextPosition(1, 2);
        TextPosition pos2 = new TextPosition(0, 1);
        positions.add(pos1);
        positions.add(pos2);
        positions.sort();
        assertTrue(pos1 == positions.get(1));
        assertTrue(pos2 == positions.get(0));
    }

    @Test
    public void removeOverlappingAtEmptyTextPositions() {
        TextPositions positions = new TextPositions();
        int oldSize = positions.size();
        positions.removeOverlapping();
        int newSize = positions.size();
        assertTrue(oldSize == newSize);
    }

    @Test
    public void removeOverlappingForNotOverLappingTextPositions() {
        TextPositions positions = new TextPositions();
        TextPosition pos1 = new TextPosition(0, 5);
        TextPosition pos2 = new TextPosition(6, 8);
        positions.add(pos1);
        positions.add(pos2);
        int oldSize = positions.size();
        positions.removeOverlapping();
        int newSize = positions.size();
        assertTrue(oldSize == newSize);
        assertTrue(pos1 == positions.get(0));
        assertTrue(pos2 == positions.get(1));
    }

    @Test
    public void removeOverlappingAtTwoSameTextPositions() {
        TextPositions positions = new TextPositions();
        TextPosition pos1 = new TextPosition(0, 5);
        TextPosition pos2 = new TextPosition(0, 5);
        positions.add(pos1);
        positions.add(pos2);
        int oldSize = positions.size();
        positions.removeOverlapping();
        int newSize = positions.size();
        assertTrue(oldSize - 1 == newSize);
        TextPosition melted = positions.get(0);
        assertEquals(pos1, melted);
        assertEquals(pos2, melted);
    }

    @Test
    public void removeOverlappingAtThreeSameTextPositions() {
        TextPositions positions = new TextPositions();
        TextPosition pos1 = new TextPosition(0, 5);
        TextPosition pos2 = new TextPosition(0, 5);
        TextPosition pos3 = new TextPosition(0, 5);
        positions.add(pos1);
        positions.add(pos2);
        positions.add(pos3);
        positions.removeOverlapping();
        int newSize = positions.size();
        assertTrue(1 == newSize);
        TextPosition melted = positions.get(0);
        assertEquals(pos1, melted);
        assertEquals(pos2, melted);
        assertEquals(pos3, melted);
    }

    @Test
    public void removeOverlappingAtTwoOverlappingTextPositions() {
        TextPositions positions = new TextPositions();
        TextPosition pos1 = new TextPosition(0, 5);
        TextPosition pos2 = new TextPosition(4, 7);
        positions.add(pos1);
        positions.add(pos2);
        positions.removeOverlapping();
        int newSize = positions.size();
        assertTrue(1 == newSize);
        TextPosition melted = positions.get(0);
        assertEquals(pos1.getBegin(), melted.getBegin());
        assertEquals(pos2.getEnd(), melted.getEnd());
    }

    @Test
    public void removeOverlappingAtThreeOverlappingTextPositions() {
        TextPositions positions = new TextPositions();
        TextPosition pos1 = new TextPosition(0, 5);
        TextPosition pos2 = new TextPosition(4, 7);
        TextPosition pos3 = new TextPosition(6, 12);
        positions.add(pos1);
        positions.add(pos2);
        positions.add(pos3);
        positions.removeOverlapping();
        int newSize = positions.size();
        assertTrue(1 == newSize);
        TextPosition melted = positions.get(0);
        assertEquals(pos1.getBegin(), melted.getBegin());
        assertEquals(pos3.getEnd(), melted.getEnd());
    }

    @Test
    public void removeOverlappingAtThreeUnsortedOverlappingTextPositions() {
        TextPositions positions = new TextPositions();
        TextPosition pos1 = new TextPosition(4, 7);
        TextPosition pos2 = new TextPosition(6, 12);
        TextPosition pos3 = new TextPosition(0, 5);
        positions.add(pos1);
        positions.add(pos2);
        positions.add(pos3);
        positions.removeOverlapping();
        int newSize = positions.size();
        assertTrue(1 == newSize);
        TextPosition melted = positions.get(0);
        assertEquals(pos3.getBegin(), melted.getBegin());
        assertEquals(pos2.getEnd(), melted.getEnd());
    }

    @Test
    public void removeOverlappingAtTwoOverlappingTupels() {
        TextPositions positions = new TextPositions();
        TextPosition pos1a = new TextPosition(0, 5);
        TextPosition pos1b = new TextPosition(4, 7);
        TextPosition pos2a = new TextPosition(10, 15);
        TextPosition pos2b = new TextPosition(14, 17);
        positions.add(pos1a);
        positions.add(pos1b);
        positions.add(pos2a);
        positions.add(pos2b);
        positions.removeOverlapping();
        int newSize = positions.size();
        assertTrue(2 == newSize);
        TextPosition melted1 = positions.get(0);
        TextPosition melted2 = positions.get(1);
        assertEquals(pos1a.getBegin(), melted1.getBegin());
        assertEquals(pos1b.getEnd(), melted1.getEnd());
        assertEquals(pos2a.getBegin(), melted2.getBegin());
        assertEquals(pos2b.getEnd(), melted2.getEnd());
    }

}
