package de.duehl.basics.text.xml;

/*
 * Copyright 2023 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

import de.duehl.basics.collections.CollectionsHelper;

public class MultiLineTagJoinerTest {

    @Test
    public void emptyLines() {
        List<String> lines = CollectionsHelper.buildListFrom("");
        String tag = "foo";
        MultiLineTagJoiner joiner = new MultiLineTagJoiner(lines, tag);
        joiner.join();
        List<String> expectedlines = CollectionsHelper.buildListFrom("");
        assertEquals(expectedlines, lines);
    }

    @Test
    public void twoLines() {
        List<String> lines = CollectionsHelper.buildListFrom(
                "    <bar>Bar Bar Barberei</bar>",
                "    <foo>Das ist der Inhalt,",
                "        der sich auf zwei Zeilen erstreckt.</foo>",
                "    <baz>batzen</baz>",
                "    <foo>einzeilig</foo>"
                );
        String tag = "foo";
        MultiLineTagJoiner joiner = new MultiLineTagJoiner(lines, tag);
        joiner.join();
        List<String> expectedlines = CollectionsHelper.buildListFrom(
                "    <bar>Bar Bar Barberei</bar>",
                "    <foo>Das ist der Inhalt, der sich auf zwei Zeilen erstreckt.</foo>",
                "    <baz>batzen</baz>",
                "    <foo>einzeilig</foo>"
                );
        assertEquals(expectedlines, lines);
    }

    @Test
    public void twoLinesWrongTag() {
        List<String> lines = CollectionsHelper.buildListFrom(
                "    <bar>Bar Bar Barberei</bar>",
                "    <foo>Das ist der Inhalt,",
                "        der sich auf zwei Zeilen erstreckt.</foo>",
                "    <baz>batzen</baz>",
                "    <foo>einzeilig</foo>"
                );
        String tag = "fooBar";
        MultiLineTagJoiner joiner = new MultiLineTagJoiner(lines, tag);
        joiner.join();
        List<String> expectedlines = CollectionsHelper.buildListFrom(
                "    <bar>Bar Bar Barberei</bar>",
                "    <foo>Das ist der Inhalt,",
                "        der sich auf zwei Zeilen erstreckt.</foo>",
                "    <baz>batzen</baz>",
                "    <foo>einzeilig</foo>"
                );
        assertEquals(expectedlines, lines);
    }

    @Test
    public void addAlternativEnd1() {
        List<String> lines = CollectionsHelper.buildListFrom(
                "                <pub_un_logo_kopf Datei=\"230412043388_00-0.jpg\" Format=\"JPEG\"/>",
                "                <Z-Titel Groesse=\"gross\">HSV Systemverkehre GmbH</Z-Titel>",
                "                <Z-Titel>Friedewald</Z-Titel>",
                "                <Titel>",
                "                   <L-Titel>Jahresabschluss zum Geschäftsjahr vom 01.01.2021 bis zum 31.12.2021</L-Titel>",
                "                </Titel>"
                );
        String tag = "pub_un_logo_kopf";
        MultiLineTagJoiner joiner = new MultiLineTagJoiner(lines, tag);
        joiner.addAlternativEnd("Format=\"JPEG\"/>");
        joiner.join();
        List<String> expectedlines = CollectionsHelper.buildListFrom(
                "                <pub_un_logo_kopf Datei=\"230412043388_00-0.jpg\" Format=\"JPEG\"/>",
                "                <Z-Titel Groesse=\"gross\">HSV Systemverkehre GmbH</Z-Titel>",
                "                <Z-Titel>Friedewald</Z-Titel>",
                "                <Titel>",
                "                   <L-Titel>Jahresabschluss zum Geschäftsjahr vom 01.01.2021 bis zum 31.12.2021</L-Titel>",
                "                </Titel>"
                );
        assertEquals(expectedlines, lines);
    }

}
