package de.duehl.html.download.binary;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

/**
 * Lädt eine binäre Datei vom Webserver.
 *
 * Siehe
 *   https://stackoverflow.com/questions/10960409/how-do-i-save-a-file-downloaded-with-httpclient-into-a-specific-folder
 *   https://coderanch.com/t/676274/java/download-binary-file-web-server
 *
 * @version 1.01     2024-10-13
 * @author Christian Dühl
 */

public class SimpleBinaryFileDownloader {

    /**
     * Lädt eine binäre Datei vom Webserver herunter.
     *
     * @param remoteFileUrl
     *            Die URL der Datei auf dem Webserver.
     * @param localFilename
     *            Der lokale Dateiname unter dem die Datei abgelegt werden soll. Diese wird im
     *            Zweifelsfall überschrieben.
     */
    public static void downloadBinaryFile(String remoteFileUrl, String localFilename) {
        try {
            tryToDownloadBinaryFile(remoteFileUrl, localFilename);
        }
        catch (Exception exception) {
            throw new RuntimeException("Fehler beim Versuch die Datei unter der URL '"
                    + remoteFileUrl + "' herunterzuladen und unter der Datei '" + localFilename
                    + "' abzuspeichern.", exception);
        }
    }

    private static void tryToDownloadBinaryFile(String remoteFileUrl, String localFilename)
            throws ClientProtocolException, IOException {
        File myFile = new File(localFilename);

        CloseableHttpClient client = HttpClients.createDefault();
        try (CloseableHttpResponse response = client.execute(new HttpGet(remoteFileUrl))) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try (FileOutputStream outstream = new FileOutputStream(myFile)) {
                    entity.writeTo(outstream);
                }
            }
        }
    }

}
