package de.duehl.html.download.data;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Enum-Klasse stellt einen HTTP-Status dar.
 *
 * @see https://de.wikipedia.org/wiki/HTTP-Statuscode
 *
 * @version 1.01     2017-05-18
 * @author Christian Dühl
 */

public enum DownloadStatus {

    OK(200, "HTTP/1.1 200 OK"), // alles gut, Seite konnte heruntergeladen werden.
    MOVED_PERMANENTLY(301, "HTTP/1.1 301 Moved Permanently"),
    MOVED_TEMPORARILY(302, "HTTP/1.1 302 Found"),
    SEE_OTHER(303, "HTTP/1.1 303 weiß ich noch nicht..."),
    TEMPORARILY_REDIRECTED(307, "HTTP/1.1 304 weiß ich noch nicht..."),
    FAILURE(-1, "Keiner der Versuche hatte Erfolg."),
    NOT_LOADED(-2, "Noch nicht mit dem Laden begonnen."),
    PAGE_NOT_FOUND(-3, "Seite nicht gefunden"),
    DOWNLOAD_CANCELED(-4, "Download nach Zeitüberschreitung abgebrochen"),
    UNKNOWN(-5, "Unknown"),
    ;

    /*
     * TODO fraglich ob die Zahlen hier überhaupt Sinn machen... - überlegen..
     *
     * NEIN:
     * Es ist auch fraglich, ob dieser Code überhaupt Sinn macht... er wird nirgends verwendet.
     * Nur für isDownloadSuccessfull() mit  status == DownloadStatus.OK
     * Ahja doch, die Statuswerte werden im Downloader selbst verwendet. Ist nur die Frage, ob man
     * sie nach Außen weiter gibt. Es schadet aber auch nichts.
     */

    /** Status-Code (200, 302, ...) */
    private final int statusCode;
    private final String description;

    DownloadStatus(int statusCode, String description) {
        this.statusCode = statusCode;
        this.description = description;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public String getDescription() {
        return description;
    }

//    public static DownloadStatus getFromDescription(String description) {
//        for (DownloadStatus dec : values()) {
//            if (description.equals(dec.getDescription())) {
//                return dec;
//            }
//        }
//
//        return UNKNOWN;
//    }

    public static DownloadStatus getFromStatusCode(int statusCode) {
        for (DownloadStatus dec : values()) {
            if (statusCode == dec.getStatusCode()) {
                return dec;
            }
        }

        return UNKNOWN;
    }

}
