package de.duehl.html.download.start;

import de.duehl.basics.logging.LogEntry;
import de.duehl.basics.logging.MemoryLogger;
import de.duehl.html.download.Downloader;
import de.duehl.html.download.data.DownloadInfo;
import de.duehl.html.download.proxy.Proxy;

public class RunDownloaderDuehlDeTextFile {

    public static final Proxy PROXY_40 = new Proxy("192.168.32.40", 3128);

    public static void main(String[] args) {
        MemoryLogger logger = new MemoryLogger();
        Downloader downloader = new Downloader("https://www.duehl.de/vokabel_trainer_japanisch/"
                + "Neuste_Version_Programm.txt")
                .setLogger(logger)
                .useProxy(PROXY_40)
                .disableRedirectHandling()
                .multipleDownloadTries(10, 120)
                ;
        DownloadInfo info = downloader.download();

        System.out.println("Status: " + info.getStatus().getStatusCode() + " - "
                + info.getStatus().getDescription());
        System.out.println("Original-Status-Code: " + info.getOriginalHttpStatusCode());
        System.out.println("Originale Url : " + info.getUrl());
        System.out.println("Redirected Url: " + info.getReturnedUrl());
        System.out.println("Seitentext:\n" + info.getContent());

        System.out.println(LogEntry.toNiceString(logger.getLogEntries()));
    }

}
