package de.duehl.swing.debug.dialog.table;

import de.duehl.swing.ui.tables.BasicTableColumnModel;

/**
 * Diese Klasse stellt das Column-Modell der Tabelle mit den Debugmeldungen dar.
 *
 * @version 1.02     2025-07-29
 * @author Christian Dühl
 */

public class DebugMessagesColumnModel extends BasicTableColumnModel {

    private static final long serialVersionUID = 1L;

    /**
     * Die Tabelle enthält die folgenden Spalten:
     *     - Datum
     *     - Uhrzeit
     *     - Kategorie (sofern sie angezeigt werden soll)
     *     - Klassenname
     *     - Methodenname
     *     - Zeilennummer
     *     - Meldung
     *
     * @param showCategory gui
     *            Gibt an, ob die Spalte mit der Kategorie angezeigt werden soll.
     */
    public DebugMessagesColumnModel(boolean showCategory) {
        addMinMaxWidthColumn(80, "Datum");
        addMinMaxWidthColumn(80, "Uhrzeit");
        if (showCategory) {
            addMinWidthColumn(120, "Kategorie");
        }
        addMinWidthColumn(90, "Klasse");
        addMinWidthColumn(90, "Methode");
        addMinWidthColumn(40, "Zeile");
        addMinWidthColumn(300, "Meldung");
    }

}
