package de.duehl.swing.ui.area;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.JTextArea;

/**
 * Diese Klasse stellt einen KeyListener für TextAreas zur Verfügung, mit dem das Betätigen des
 * Tabulators nicht zu einer Eingabe führt, sondern in der Fokusreihenfolge weitergeht.
 *
 * @version 1.01     2020-01-15
 * @author Christian Dühl
 */

public class NotEnteringTabulatorKeyListener extends KeyAdapter {

    private final JTextArea textArea;

    public NotEnteringTabulatorKeyListener(JTextArea textArea) {
        this.textArea = textArea;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == KeyEvent.VK_TAB) {
            if (event.getModifiersEx() > 0) {
                textArea.transferFocusBackward();
            }
            else {
                textArea.transferFocus();
            }
            event.consume();
        }
    }

}
