package de.duehl.swing.ui.buttons.painted;

import java.awt.Color;

import de.duehl.swing.ui.geometry.PixelPoint;

/**
 * Diese Klasse stellt einen kleinen Schalter zum Weiterschalten dar.
 * Eine quadratische Ansicht wird nicht unterstützt.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public class NextButton extends PaintedButton {

    private static final long serialVersionUID = -1L;

    /** Konstruktor mit schwarzer Farbe. */
    public NextButton() {
        this(Color.BLACK);
    }

    /**
     * Konstruktor.
     *
     * @param symbolColor
     *            Die Farbe des Symbols.
     */
    public NextButton(Color symbolColor) {
        super(symbolColor);
    }

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintHorizontalSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintVerticalSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintHorizontalSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintVerticalSymbol();
    }

    /**
     * Zeichnet das Symbol in horizontaler Anordnung. isForceSquare() wird ignoriert.
     *
     *    1
     *  6   .
     *    .   .
     *       .   .
     *         .    .
     *           5     2
     *        .    .
     *      .   .
     *    .  .
     *  4   .
     *    3
     */
    private void paintHorizontalSymbol() {
        int delta = 6;
        int off = delta / 2;
        int left = delta;
        int right = getWidth() - delta - 1;
        int upper = delta;
        int lower = getHeight() - delta - 1;
        int hightCenter = getHeight() / 2;

        paintPolygon(
                new PixelPoint(left + off,     upper      ), //  1
                new PixelPoint(right,          hightCenter), //  2
                new PixelPoint(left + off,     lower      ), //  3
                new PixelPoint(left,           lower - off), //  4
                new PixelPoint(right - 3*off,  hightCenter), //  5
                new PixelPoint(left,           upper + off)  //  6
                );
    }

    /**
     * Zeichnet das Symbol in vertikaler Anordnung. isForceSquare() wird ignoriert.
     *
     *     6                 4
     *   1   .            .    3
     *     .     .     .     .
     *        .     5     .
     *           .     .
     *              2
     */
    private void paintVerticalSymbol() {
        int delta = 6;
        int off = delta / 2;
        int left = delta;
        int right = getWidth() - delta - 1;
        int upper = delta;
        int lower = getHeight() - delta - 1;
        int widthCenter = getWidth() / 2;

        paintPolygon(
                new PixelPoint(left,         upper + off  ), //  1
                new PixelPoint(widthCenter,  lower        ), //  2
                new PixelPoint(right,        upper + off  ), //  3
                new PixelPoint(right - off,  upper        ), //  4
                new PixelPoint(widthCenter,  lower - 3*off), //  5
                new PixelPoint(left + off,   upper        )  //  6
                );
    }

}
