package de.duehl.swing.ui.buttons.painted;

import java.awt.Color;

import de.duehl.swing.ui.geometry.PixelPoint;

/**
 * Diese Klasse stellt einen kleinen Schalter zum Hinzufügen von etwas dar.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public class PlusButton extends PaintedButton {

    private static final long serialVersionUID = -1441507523499749679L;

    /** Konstruktor mit schwarzer Farbe. */
    public PlusButton() {
        this(Color.BLACK);
    }

    /**
     * Konstruktor.
     *
     * @param symbolColor
     *            Die Farbe des Symbols.
     */
    public PlusButton(Color symbolColor) {
        super(symbolColor);
    }

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das kleine Pluszeichen zum Hinzufügen. */
    private void paintSymbol() {
        int width = getWidth();
        int height = getHeight();

        if (isForceSquare()) {
            width = Math.min(width, height);
            height = width;
        }

        int delta = 3;

        int firstLeftPixel = (getWidth() - width)/2;
        int left = firstLeftPixel + delta;

        int lastRightPixel = firstLeftPixel + width - 1;
        int right = lastRightPixel - delta;

        int firstUpperPixel = (getHeight() - height)/2;
        int upper = firstUpperPixel + delta;

        int lastLowerPixel = firstUpperPixel + height - 1;
        int lower = lastLowerPixel - delta;

        int midWidth  = firstLeftPixel + width / 2;
        int midHeight = firstUpperPixel + height / 2;
        paintLine(
                new PixelPoint(left,   midHeight),
                new PixelPoint(right,  midHeight)
                );
        paintLine(
                new PixelPoint(midWidth,  upper),
                new PixelPoint(midWidth,  lower)
                );
    }

    /**
     * Zeichnet das kleine Pluszeichen zum Hinzufügen.
     *
     *           3---4
     *           |   |
     *           |   |
     *           |   |
     *   1-------2   5-------6
     *   |                   |
     *  12------11   8-------7
     *           |   |
     *           |   |
     *           |   |
     *          10---9
     */
    @SuppressWarnings("unused")
    private void paintOldPlusSymbol() {
        int width = getWidth();
        int height = getHeight();

        if (isForceSquare()) {
            width = Math.min(width, height);
            height = width;
        }

        int delta = 3;

        int firstLeftPixel = (getWidth() - width)/2;
        int left = firstLeftPixel + delta;

        int lastRightPixel = firstLeftPixel + width - 1;
        int right = lastRightPixel - delta;

        int firstUpperPixel = (getHeight() - height)/2;
        int upper = firstUpperPixel + delta;

        int lastLowerPixel = firstUpperPixel + height - 1;
        int lower = lastLowerPixel - delta;

        int innerDelta = 1; // Könnte man abhängig von der minimalen Ausdehnung auf 10 oder
                            // weniger setzen.
                            // Dann aber auch analog bei Minus und X.
                            // Warum überhaupt so und nicht zwei Linien?

        int widthCenter = firstLeftPixel + width / 2;
        int hightCenter = firstUpperPixel + height / 2;
        int leftCenter  = widthCenter - innerDelta;
        int rightCenter = widthCenter + innerDelta;
        int upperCenter = hightCenter - innerDelta;
        int lowerCenter = hightCenter + innerDelta;

        paintPolygon(
                new PixelPoint(left,         upperCenter),  //  1
                new PixelPoint(leftCenter,   upperCenter),  //  2
                new PixelPoint(leftCenter,   upper      ),  //  3
                new PixelPoint(rightCenter,  upper      ),  //  4
                new PixelPoint(rightCenter,  upperCenter),  //  5
                new PixelPoint(right,        upperCenter),  //  6
                new PixelPoint(right,        lowerCenter),  //  7
                new PixelPoint(rightCenter,  lowerCenter),  //  8
                new PixelPoint(rightCenter,  lower      ),  //  9
                new PixelPoint(leftCenter,   lower      ),  // 10
                new PixelPoint(leftCenter,   lowerCenter),  // 11
                new PixelPoint(left,         lowerCenter)   // 12
                );
    }

}
