package de.duehl.swing.ui.buttons.painted;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BasicStroke;
import java.awt.Color;

import de.duehl.swing.ui.geometry.PixelPoint;

/**
 * Diese Klasse stellt einen kleinen Schalter zum Hinzufügen von etwas dar, der von einem Kasten
 * umrandet ist.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public class PlusInABoxButton extends PaintedButton {

    private static final long serialVersionUID = -1441507523499749679L;

    /** Konstruktor mit schwarzer Farbe. */
    public PlusInABoxButton() {
        this(Color.BLACK);
    }

    /**
     * Konstruktor.
     *
     * @param symbolColor
     *            Die Farbe des Symbols.
     */
    public PlusInABoxButton(Color symbolColor) {
        super(symbolColor);
    }

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das kleine Pluszeichen zum Hinzufügen. */
    private void paintSymbol() {
        int width = getWidth();
        int height = getHeight();

        if (isForceSquare()) {
            width = Math.min(width, height);
            height = width;
        }

        int delta = 6;

        int firstLeftPixel = (getWidth() - width)/2;
        int left = firstLeftPixel + delta;

        int lastRightPixel = firstLeftPixel + width - 1;
        int right = lastRightPixel - delta;

        int firstUpperPixel = (getHeight() - height)/2;
        int upper = firstUpperPixel + delta;

        int lastLowerPixel = firstUpperPixel + height - 1;
        int lower = lastLowerPixel - delta;

        //graphics2.setColor(Color.RED);
        paintUnfilledRectangle(
                new PixelPoint(left,  upper),
                new PixelPoint(right, lower)
                );
        //graphics2.setColor(Color.BLACK);

        //int deltaBox = Math.min(20, Math.min(width, height)/20);
        int deltaBox = Math.min(width, height)/10;
        int midWidth  = firstLeftPixel + width / 2;
        int midHeight = firstUpperPixel + height / 2;

        paintLine(
                new PixelPoint(left + deltaBox,   midHeight),
                new PixelPoint(right - deltaBox,  midHeight)
                );
        paintLine(
                new PixelPoint(midWidth,  upper + deltaBox),
                new PixelPoint(midWidth,  lower - deltaBox)
                );
    }

    /** Setzt die Strichstärke. */
    @Override
    protected void setStroke() {
        graphics2.setStroke(new BasicStroke(1));
    }

}
