package de.duehl.swing.ui.colors;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;

/**
 * Diese Klasse kann eine Liste sehr vielen benannten Farben erzeugen.
 *
 * @see de.heinsundpartner.hr.wz.application.ui.BranchesOfTradeGui#createJavaColor
 *
 * @version 1.01     2020-01-24
 * @author Christian Dühl
 */

public class NamedColorListFabric {

    public static final String ALICEBLUE = "aliceblue";
    public static final String ANTIQUEWHITE = "antiquewhite";
    public static final String AQUA = "aqua";
    public static final String AQUAMARINE = "aquamarine";
    public static final String AUBERGINE = "aubergine";
    public static final String AZURE = "azure";
    public static final String BEIGE = "beige";
    public static final String BISQUE = "bisque";
    public static final String BLACK = "black";
    public static final String BLANCHEDALMOND = "blanchedalmond";
    public static final String BLUE = "blue";
    public static final String BLUEVIOLET = "blueviolet";
    public static final String BROWN = "brown";
    public static final String BURLYWOOD = "burlywood";
    public static final String CADETBLUE = "cadetblue";
    public static final String CHARTREUSE = "chartreuse";
    public static final String CHOCOLATE = "chocolate";
    public static final String CORAL = "coral";
    public static final String CORNFLOWERBLUE = "cornflowerblue";
    public static final String CORNSILK = "cornsilk";
    public static final String CRIMSON = "crimson";
    public static final String CYAN = "cyan";
    public static final String DARKBLUE = "darkblue";
    public static final String DARKCYAN = "darkcyan";
    public static final String DARKGOLDENROD = "darkgoldenrod";
    public static final String DARKGRAY = "darkgray";
    public static final String DARKGREEN = "darkgreen";
    public static final String DARKGREY = "darkgrey";
    public static final String DARKKHAKI = "darkkhaki";
    public static final String DARKMAGENTA = "darkmagenta";
    public static final String DARKOLIVEGREEN = "darkolivegreen";
    public static final String DARKORANGE = "darkorange";
    public static final String DARKORCHID = "darkorchid";
    public static final String DARKRED = "darkred";
    public static final String DARKSALMON = "darksalmon";
    public static final String DARKSEAGREEN = "darkseagreen";
    public static final String DARKSLATEBLUE = "darkslateblue";
    public static final String DARKSLATEGRAY = "darkslategray";
    public static final String DARKTURQUOISE = "darkturquoise";
    public static final String DARKVIOLET = "darkviolet";
    public static final String DEEPPINK = "deeppink";
    public static final String DEEPSKYBLUE = "deepskyblue";
    public static final String DIMGRAY = "dimgray";
    public static final String DIMGREY = "dimgrey";
    public static final String DODGERBLUE = "dodgerblue";
    public static final String FIREBRICK = "firebrick";
    public static final String FLORALWHITE = "floralwhite";
    public static final String FORESTGREEN = "forestgreen";
    public static final String FUCHSIA = "fuchsia";
    public static final String GAINSBORO = "gainsboro";
    public static final String GHOSTWHITE = "ghostwhite";
    public static final String GOLD = "gold";
    public static final String GOLDENROD = "goldenrod";
    public static final String GRAY = "gray";
    public static final String GREY = "grey";
    public static final String GREEN = "green";
    public static final String GREENYELLOW = "greenyellow";
    public static final String HONEYDEW = "honeydew";
    public static final String HOTPINK = "hotpink";
    public static final String INDIANRED = "indianred";
    public static final String INDIGO = "indigo";
    public static final String IVORY = "ivory";
    public static final String KHAKI = "khaki";
    public static final String LAVENDER = "lavender";
    public static final String LAVENDERBLUSH = "lavenderblush";
    public static final String LAWNGREEN = "lawngreen";
    public static final String LEMONCHIFFON = "lemonchiffon";
    public static final String LIGHTBLUE = "lightblue";
    public static final String LIGHTCORAL = "lightcoral";
    public static final String LIGHTCYAN = "lightcyan";
    public static final String LIGHTGOLDENRODYELLOW = "lightgoldenrodyellow";
    public static final String LIGHTGREY = "lightgrey";
    public static final String LIGHTGRAY = "lightgray";
    public static final String LIGHTGREEN = "lightgreen";
    public static final String LIGHTPINK = "lightpink";
    public static final String LIGHTRED = "lightred";
    public static final String LIGHTSALMON = "lightsalmon";
    public static final String LIGHTSEAGREEN = "lightseagreen";
    public static final String LIGHTSKYBLUE = "lightskyblue";
    public static final String LIGHTSLATEGRAY = "lightslategray";
    public static final String LIGHTSTEELBLUE = "lightsteelblue";
    public static final String LIGHTYELLOW = "lightyellow";
    public static final String LIME = "lime";
    public static final String LIMEGREEN = "limegreen";
    public static final String LINEN = "linen";
    public static final String MAGENTA = "magenta";
    public static final String MAROON = "maroon";
    public static final String MEDIUMAQUAMARINE = "mediumaquamarine";
    public static final String MEDIUMBLUE = "mediumblue";
    public static final String MEDIUMORCHID = "mediumorchid";
    public static final String MEDIUMPURPLE = "mediumpurple";
    public static final String MEDIUMSEAGREEN = "mediumseagreen";
    public static final String MEDIUMSLATEBLUE = "mediumslateblue";
    public static final String MEDIUMSPRINGGREEN = "mediumspringgreen";
    public static final String MEDIUMTURQUOISE = "mediumturquoise";
    public static final String MEDIUMVIOLETRED = "mediumvioletred";
    public static final String MIDNIGHTBLUE = "midnightblue";
    public static final String MINTCREAM = "mintcream";
    public static final String MISTYROSE = "mistyrose";
    public static final String MOCCASIN = "moccasin";
    public static final String NAVAJOWHITE = "navajowhite";
    public static final String NAVY = "navy";
    public static final String OLDLACE = "oldlace";
    public static final String OLIVE = "olive";
    public static final String OLIVEDRAB = "olivedrab";
    public static final String ORANGE = "orange";
    public static final String ORANGEALTERNATIVE = "orangealternative";
    public static final String ORANGERED = "orangered";
    public static final String ORCHID = "orchid";
    public static final String PALEGOLDENROD = "palegoldenrod";
    public static final String PALEGREEN = "palegreen";
    public static final String PALETURQUOISE = "paleturquoise";
    public static final String PALEVIOLETRED = "palevioletred";
    public static final String PAPAYAWHIP = "papayawhip";
    public static final String PEACHPUFF = "peachpuff";
    public static final String PERU = "peru";
    public static final String PINK = "pink";
    public static final String PLUM = "plum";
    public static final String POWDERBLUE = "powderblue";
    public static final String PURPLE = "purple";
    public static final String RED = "red";
    public static final String ROSYBROWN = "rosybrown";
    public static final String ROYALBLUE = "royalblue";
    public static final String SADDLEBROWN = "saddlebrown";
    public static final String SALMON = "salmon";
    public static final String SANDYBROWN = "sandybrown";
    public static final String SEAGREEN = "seagreen";
    public static final String SEASHELL = "seashell";
    public static final String SIENNA = "sienna";
    public static final String SILVER = "silver";
    public static final String SKYBLUE = "skyblue";
    public static final String SLATEBLUE = "slateblue";
    public static final String SLATEGRAY = "slategray";
    public static final String SNOW = "snow";
    public static final String SPRINGGREEN = "springgreen";
    public static final String STEELBLUE = "steelblue";
    public static final String TAN = "tan";
    public static final String TEAL = "teal";
    public static final String THISTLE = "thistle";
    public static final String TOMATO = "tomato";
    public static final String TURQUOISE = "turquoise";
    public static final String VIOLET = "violet";
    public static final String WHEAT = "wheat";
    public static final String WHITE = "white";
    public static final String WHITESMOKE = "whitesmoke";
    public static final String YELLOW = "yellow";
    public static final String YELLOWGREEN = "yellowgreen";

    private static NamedColorList namedColorList;

    /**
     * Erzeugt eine Liste mit sehr vielen benannten Farben.
     *
     * @see <a href="http://tomheller.de/theholycymbal/html-farben.html"
     *      >Weitere Farben</a>
     *
     * @return Liste mit benannten Farben und ihren hexadezimalen Farbwerten.
     */
    public NamedColorList genrateColorList() {
        NamedColorList list = new NamedColorList();

        list.add(new NamedColor(ALICEBLUE, "f0f8ff"));
        list.add(new NamedColor(ANTIQUEWHITE, "faebd7"));
        list.add(new NamedColor(AQUA, "00ffff"));
        list.add(new NamedColor(AQUAMARINE, "7fffd4"));
        list.add(new NamedColor(AUBERGINE, "693b58"));
        list.add(new NamedColor(AZURE, "f0ffff"));
        list.add(new NamedColor(BEIGE, "f5f5dc"));
        list.add(new NamedColor(BISQUE, "ffe4c4"));
        list.add(new NamedColor(BLACK, "000000"));
        list.add(new NamedColor(BLANCHEDALMOND, "ffebcd"));
        list.add(new NamedColor(BLUE, "0000ff"));
        list.add(new NamedColor(BLUEVIOLET, "8a2be2"));
        list.add(new NamedColor(BROWN, "a52a2a"));
        list.add(new NamedColor(BURLYWOOD, "deb887"));
        list.add(new NamedColor(CADETBLUE, "5f9ea0"));
        list.add(new NamedColor(CHARTREUSE, "7fff00"));
        list.add(new NamedColor(CHOCOLATE, "d2691e"));
        list.add(new NamedColor(CORAL, "ff7f50"));
        list.add(new NamedColor(CORNFLOWERBLUE, "6495ed"));
        list.add(new NamedColor(CORNSILK, "fff8dc"));
        list.add(new NamedColor(CRIMSON, "dc143c"));
        list.add(new NamedColor(CYAN, "00ffff"));
        list.add(new NamedColor(DARKBLUE, "00008b"));
        list.add(new NamedColor(DARKCYAN, "008b8b"));
        list.add(new NamedColor(DARKGOLDENROD, "b8860b"));
        list.add(new NamedColor(DARKGRAY, "a9a9a9"));
        list.add(new NamedColor(DARKGREEN, "006400"));
        list.add(new NamedColor(DARKGREY, "a9a9a9"));
        list.add(new NamedColor(DARKKHAKI, "bdb76b"));
        list.add(new NamedColor(DARKMAGENTA, "8b008b"));
        list.add(new NamedColor(DARKOLIVEGREEN, "556B2f"));
        list.add(new NamedColor(DARKORANGE, "ff8c00"));
        list.add(new NamedColor(DARKORCHID, "9932cc"));
        list.add(new NamedColor(DARKRED, "8b0000"));
        list.add(new NamedColor(DARKSALMON, "e9967a"));
        list.add(new NamedColor(DARKSEAGREEN, "8fbc8f"));
        list.add(new NamedColor(DARKSLATEBLUE, "483d8b"));
        list.add(new NamedColor(DARKSLATEGRAY, "2f4f4f"));
        list.add(new NamedColor(DARKTURQUOISE, "00ced1"));
        list.add(new NamedColor(DARKVIOLET, "9400d3"));
        list.add(new NamedColor(DEEPPINK, "ff1493"));
        list.add(new NamedColor(DEEPSKYBLUE, "00bfff"));
        list.add(new NamedColor(DIMGRAY, "696969"));
        list.add(new NamedColor(DIMGREY, "696969"));
        list.add(new NamedColor(DODGERBLUE, "1e90ff"));
        list.add(new NamedColor(FIREBRICK, "b22222"));
        list.add(new NamedColor(FLORALWHITE, "fffaf0"));
        list.add(new NamedColor(FORESTGREEN, "228b22"));
        list.add(new NamedColor(FUCHSIA, "ff00ff"));
        list.add(new NamedColor(GAINSBORO, "dcdcdc"));
        list.add(new NamedColor(GHOSTWHITE, "f8f8ff"));
        list.add(new NamedColor(GOLD, "ffd700"));
        list.add(new NamedColor(GOLDENROD, "daa520"));
        list.add(new NamedColor(GRAY, "808080"));
        list.add(new NamedColor(GREY, "808080"));
        list.add(new NamedColor(GREEN, "008000"));
        list.add(new NamedColor(GREENYELLOW, "adff2f"));
        list.add(new NamedColor(HONEYDEW, "f0fff0"));
        list.add(new NamedColor(HOTPINK, "ff69b4"));
        list.add(new NamedColor(INDIANRED, "cd5c5c"));
        list.add(new NamedColor(INDIGO, "4b0082"));
        list.add(new NamedColor(IVORY, "fffff0"));
        list.add(new NamedColor(KHAKI, "f0e68c"));
        list.add(new NamedColor(LAVENDER, "e6e6fa"));
        list.add(new NamedColor(LAVENDERBLUSH, "fff0f5"));
        list.add(new NamedColor(LAWNGREEN, "7cfc00"));
        list.add(new NamedColor(LEMONCHIFFON, "fffacd"));
        list.add(new NamedColor(LIGHTBLUE, "add8e6"));
        list.add(new NamedColor(LIGHTCORAL, "f08080"));
        list.add(new NamedColor(LIGHTCYAN, "e0ffff"));
        list.add(new NamedColor(LIGHTGOLDENRODYELLOW, "fafad2"));
        list.add(new NamedColor(LIGHTGREY, "d3d3d3"));
        list.add(new NamedColor(LIGHTGRAY, "d3d3d3"));
        list.add(new NamedColor(LIGHTGREEN, "90ee90"));
        list.add(new NamedColor(LIGHTPINK, "ffb6c1"));
        list.add(new NamedColor(LIGHTRED, "ffc8c8"));
        list.add(new NamedColor(LIGHTSALMON, "ffa07a"));
        list.add(new NamedColor(LIGHTSEAGREEN, "20b2aa"));
        list.add(new NamedColor(LIGHTSKYBLUE, "87cefa"));
        list.add(new NamedColor(LIGHTSLATEGRAY, "778899"));
        list.add(new NamedColor(LIGHTSTEELBLUE, "b0c4de"));
        list.add(new NamedColor(LIGHTYELLOW, "ffffe0"));
        list.add(new NamedColor(LIME, "00ff00"));
        list.add(new NamedColor(LIMEGREEN, "32cd32"));
        list.add(new NamedColor(LINEN, "faf0e6"));
        list.add(new NamedColor(MAGENTA, "ff00ff"));
        list.add(new NamedColor(MAROON, "800000"));
        list.add(new NamedColor(MEDIUMAQUAMARINE, "66cdaa"));
        list.add(new NamedColor(MEDIUMBLUE, "0000cd"));
        list.add(new NamedColor(MEDIUMORCHID, "ba55d3"));
        list.add(new NamedColor(MEDIUMPURPLE, "9370db"));
        list.add(new NamedColor(MEDIUMSEAGREEN, "3cb371"));
        list.add(new NamedColor(MEDIUMSLATEBLUE, "7b68ee"));
        list.add(new NamedColor(MEDIUMSPRINGGREEN, "00fa9a"));
        list.add(new NamedColor(MEDIUMTURQUOISE, "48d1cc"));
        list.add(new NamedColor(MEDIUMVIOLETRED, "c71585"));
        list.add(new NamedColor(MIDNIGHTBLUE, "191970"));
        list.add(new NamedColor(MINTCREAM, "f5fffa"));
        list.add(new NamedColor(MISTYROSE, "ffe4e1"));
        list.add(new NamedColor(MOCCASIN, "ffe4b5"));
        list.add(new NamedColor(NAVAJOWHITE, "ffdead"));
        list.add(new NamedColor(NAVY, "000080"));
        list.add(new NamedColor(OLDLACE, "fdf5e6"));
        list.add(new NamedColor(OLIVE, "808000"));
        list.add(new NamedColor(OLIVEDRAB, "6b8e23"));
        list.add(new NamedColor(ORANGE, "ff6600"));
        list.add(new NamedColor(ORANGEALTERNATIVE, "ffa500"));
        list.add(new NamedColor(ORANGERED, "ff4500"));
        list.add(new NamedColor(ORCHID, "da70d6"));
        list.add(new NamedColor(PALEGOLDENROD, "eee8aa"));
        list.add(new NamedColor(PALEGREEN, "98fb98"));
        list.add(new NamedColor(PALETURQUOISE, "afeeee"));
        list.add(new NamedColor(PALEVIOLETRED, "db7093"));
        list.add(new NamedColor(PAPAYAWHIP, "ffefd5"));
        list.add(new NamedColor(PEACHPUFF, "ffdab9"));
        list.add(new NamedColor(PERU, "cd853f"));
        list.add(new NamedColor(PINK, "ffc0cb"));
        list.add(new NamedColor(PLUM, "dda0dd"));
        list.add(new NamedColor(POWDERBLUE, "b0e0e6"));
        list.add(new NamedColor(PURPLE, "800080"));
        list.add(new NamedColor(RED, "ff0000"));
        list.add(new NamedColor(ROSYBROWN, "bc8f8f"));
        list.add(new NamedColor(ROYALBLUE, "4169e1"));
        list.add(new NamedColor(SADDLEBROWN, "8b4513"));
        list.add(new NamedColor(SALMON, "fa8072"));
        list.add(new NamedColor(SANDYBROWN, "f4a460"));
        list.add(new NamedColor(SEAGREEN, "2e8b57"));
        list.add(new NamedColor(SEASHELL, "fff5ee"));
        list.add(new NamedColor(SIENNA, "a0522d"));
        list.add(new NamedColor(SILVER, "c0c0c0"));
        list.add(new NamedColor(SKYBLUE, "87ceeb"));
        list.add(new NamedColor(SLATEBLUE, "6a5acd"));
        list.add(new NamedColor(SLATEGRAY, "708090"));
        list.add(new NamedColor(SNOW, "fffafa"));
        list.add(new NamedColor(SPRINGGREEN, "00ff7f"));
        list.add(new NamedColor(STEELBLUE, "4682b4"));
        list.add(new NamedColor(TAN, "d2b48c"));
        list.add(new NamedColor(TEAL, "008080"));
        list.add(new NamedColor(THISTLE, "d8bfd8"));
        list.add(new NamedColor(TOMATO, "ff6347"));
        list.add(new NamedColor(TURQUOISE, "40e0d0"));
        list.add(new NamedColor(VIOLET, "ee82ee"));
        list.add(new NamedColor(WHEAT, "f5deb3"));
        list.add(new NamedColor(WHITE, "ffffff"));
        list.add(new NamedColor(WHITESMOKE, "f5f5f5"));
        list.add(new NamedColor(YELLOW, "ffff00"));
        list.add(new NamedColor(YELLOWGREEN, "9acd32"));

        return list;
    }

    /** Ermittelt eine Swing-Farbe über den Namen einer NamedColor der hier gebildeten Liste. */
    public Color getColorByName(String name) {
        lazyCreateList();

        return namedColorList.getColorByName(name);
    }

    private void lazyCreateList() {
        if (namedColorList == null) {
            namedColorList = genrateColorList();
        }
    }

    /**
     * Ermittelt eine hexadezimale Stringdarstellung über den Namen einer NamedColor der hier
     * gebildeten Liste.
     */
    public String getHexColorByName(String name) {
        lazyCreateList();

        return namedColorList.getHexCodeFromNamedColorByName(name);
    }

}
