package de.duehl.swing.ui.components.elements;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JLabel;
import javax.swing.JPanel;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.watch.StopWatchLabel;

/**
 * Diese Klasse stellt ein StopWatchLabel mit einem Titel davor dar.
 *
 * @version 1.01     2017-04-19
 * @author Christian Dühl
 */

public class TitledStopWatchLabel {

    private final JLabel titleLabel;
    private final StopWatchLabel stopWatchLabel;
    private final Component panel;
    private final Dimension titleDimension;

    public TitledStopWatchLabel(Dimension titleDimension, Color valueColor) {
        this (titleDimension, valueColor, "");
    }

    public TitledStopWatchLabel(Dimension titleDimension, Color valueColor, String title) {
        this.titleDimension = titleDimension;

        titleLabel = new JLabel(title);

        stopWatchLabel = new StopWatchLabel();
        stopWatchLabel.stop();
        stopWatchLabel.setForeground(valueColor);

        panel = createTitledValue();
    }

    private Component createTitledValue() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createTitleLabel(), BorderLayout.WEST);
        panel.add(stopWatchLabel, BorderLayout.CENTER);

        return panel;
    }

    private Component createTitleLabel() {
        titleLabel.setPreferredSize(titleDimension);
        return titleLabel;
    }

    public Component getPanel() {
        return panel;
    }

    public void setTitle(String title) {
        titleLabel.setText(title);
        panel.repaint();
    }

    public void useMonospacedFontForTheValue() {
        GuiTools.setMonospacedFont(stopWatchLabel);
        panel.repaint();
    }

    public void start() {
        stopWatchLabel.start();
    }

    public void setForeground(Color color) {
        stopWatchLabel.setForeground(color);
    }

    public void stop() {
        stopWatchLabel.stop();
    }

    public String getTime() {
        return stopWatchLabel.getTime();
    }

}
