package de.duehl.swing.ui.components.selections;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.base.FileOrPathSelection;

/**
 * Diese Klasse stellt die Auswahl einer Datei in einem Optionendialog dar.
 *
 * @version 1.01     2017-03-14
 * @author Christian Dühl
 */

public class FileSelection extends FileOrPathSelection {

    /** Endung der Datei, wie z.B. ".txt". */
    private final String extension;

    /**
     * Konstruktor.
     *
     * @param title
     *            Überschrift für die Wahl dieser Datei.
     * @param extension
     *            Endung der Datei, wie z.B. ".txt".
     */
    public FileSelection(String title, String extension) {
        super(title);
        this.extension = extension;
    }

    /**
     * Der Benutzer wählt die Datei oder das Verzeichnis aus.
     *
     * @param startDir
     *            Startverzeichnis.
     * @return Ausgewählte Benutzereingabe oder der leere String bei Abbruch durch den Benutzer.
     */
    @Override
    protected String openPath(String startDir) {
        return GuiTools.openFileWithExtension(extension, startDir);
    }

}
