package de.duehl.swing.ui.components.selections;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.base.OptionalFileOrPathSelection;

/**
 * Diese Klasse stellt die abstrakte Basis für eine Auswahl eines Verzeichnisses etwa in einem
 * Optionendialog dar.
 *
 * @version 1.01     2017-02-24
 * @author Christian Dühl
 */

public class OptionalDirSelection extends OptionalFileOrPathSelection {

    /**
     *  Konstruktor.
     *
     * @param title Überschrift für die Wahl dieses Verzeichnisses.
     */
    public OptionalDirSelection(String title) {
        super(title);
    }

    /**
     * Der Benutzer wählt die Datei oder das Verzeichnis aus.
     *
     * @param startDir
     *            Startverzeichnis.
     * @return Ausgewählte Benutzereingabe oder null bei Abbruch durch den Benutzer.
     */
    @Override
    protected String openPath(String startDir) {
        return GuiTools.openDirectory(startDir);
    }

}
