package de.duehl.swing.ui.components.selections.datetime;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;

import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSpinner.ListEditor;

import de.duehl.basics.datetime.date.Weekday;
import de.duehl.swing.ui.components.selections.datetime.spinnermodels.WeekdaySpinnerModel;

/**
 * Diese Klasse ermöglicht die Auswahl eines Wochentages.
 *
 * @version 1.01     2017-03-17
 * @author Christian Dühl
 */

public class WeekdaySelection {

    private final WeekdaySpinnerModel spinnerModel;

    private final JPanel panel;
    private final JSpinner spinner;

    public WeekdaySelection() {
        spinnerModel = new WeekdaySpinnerModel();

        spinner = new JSpinner(spinnerModel);
        ListEditor editor = new JSpinner.ListEditor(spinner);
        spinner.setEditor(editor);

        panel = createPanel();
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(spinner, BorderLayout.CENTER);

        return panel;
    }

    public JPanel getPanel() {
        return panel;
    }

    /** Getter für die Wahl des Benutzers als Test. */
    public String getText() {
        String weekday = spinnerModel.getSelectedValue();
        return weekday;
    }

    /** Getter für die Wahl des Benutzers als Weekday. */
    public Weekday getWeekday() {
        String germanName = getText();
        return Weekday.determineByGermanName(germanName);
    }

    /** Getter für die Wahl des Benutzers als Day-Code des Wochentages, beginnend mit 0 bei Montag. */
    public int getDayCode() {
        Weekday weekday = getWeekday();
        return weekday.getDayCode();
    }

    /** Setter des Textes als deutschen Wochentagnamen. */
    public void setText(String weeklyWeekdayAsGermanName) {
        spinner.setValue(weeklyWeekdayAsGermanName);
    }

}
