package de.duehl.swing.ui.components.selections.datetime.spinnermodels;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.datetime.date.Weekday;

/**
 * Diese Klasse stellt das Modell für einen Spinner dar, in dem man einen Wochentag ("Montag" bis
 * "Sonntag") auswählen kann.
 *
 * @version 1.01     2017-03-17
 * @author Christian Dühl
 */

public class WeekdaySpinnerModel extends CyclingSpinnerListModel<String> {

    private static final long serialVersionUID = 1L;

    public WeekdaySpinnerModel() {
        super(createWeekdays());
    }

    private static List<String> createWeekdays() {
        return Weekday.createGermanNamesListStartingMonday();
    }

}
