package de.duehl.swing.ui.components.selections.tools;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;

import de.duehl.swing.ui.components.selections.ComboBoxSelection;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.TextAreaSelection;

/**
 * Diese Klasse beinhaltet Hilfsmethoden um die Selections.
 *
 * @version 1.01     2025-12-15
 * @author Christian Dühl
 */

public class SelectionsHelper {

    public static final Color NOT_EDITABLE_FIELD_COLOR = new Color(240, 240, 240);
    public static final Color EDITABLE_FIELD_COLOR = new Color(255, 255, 180);

    public static void initSelectionAsViewer(StringSelection selection) {
        initSelectionAsViewer(selection, NOT_EDITABLE_FIELD_COLOR);
    }

    public static void initSelectionAsViewer(StringSelection selection, Color color) {
        initSelectionAsViewerWithoutFontSize(selection, color);
        selection.biggerText(5);
        selection.storeAsStandardFontSize();
        selection.storeAsStandardLabelFontSize();
    }

    public static void initSelectionAsViewerWithoutFontSize(StringSelection selection) {
        initSelectionAsViewerWithoutFontSize(selection, NOT_EDITABLE_FIELD_COLOR);
    }

    public static void initSelectionAsViewerWithoutFontSize(StringSelection selection, Color color) {
        selection.setEditable(false);
        selection.setFocusable(false);
        selection.setMonospacedFont();
        selection.switchLabelToBold();
        selection.setBackgroundColor(color);
    }

    public static void initSelectionAsEditor(StringSelection selection) {
        initSelectionAsEditor(selection, EDITABLE_FIELD_COLOR);
    }

    public static void initSelectionAsEditor(StringSelection selection, Color color) {
        selection.setEditable(true);
        selection.setFocusable(true);
        selection.setMonospacedFont();
        selection.switchLabelToBold();
        selection.biggerText(5);
        selection.storeAsStandardFontSize();
        selection.storeAsStandardLabelFontSize();
        selection.setBackgroundColor(color);
        selection.setRedCaretColor();
    }

    public static void initSelectionAsViewer(TextAreaSelection selection) {
        initSelectionAsViewer(selection, NOT_EDITABLE_FIELD_COLOR);
    }

    private static void initSelectionAsViewer(TextAreaSelection selection, Color color) {
        selection.setEditable(false);
        selection.setFocusable(false);
        selection.setMonospacedFont();
        selection.swithLabelToBold();
        selection.biggerText(5);
        selection.storeAsStandardFontSize();
        selection.storeAsStandardLabelFontSize();
        selection.setBackgroundColor(color);
    }

    public static void initSelectionAsEditor(TextAreaSelection selection) {
        initSelectionAsEditor(selection, NOT_EDITABLE_FIELD_COLOR);
    }

    private static void initSelectionAsEditor(TextAreaSelection selection, Color color) {
        selection.setEditable(true);
        selection.setFocusable(true);
        selection.setMonospacedFont();
        selection.swithLabelToBold();
        selection.biggerText(5);
        selection.storeAsStandardFontSize();
        selection.storeAsStandardLabelFontSize();
        selection.setBackgroundColor(color);
    }

    public static void initSelectionAsEditor(ComboBoxSelection selection) {
        initSelectionAsEditor(selection, EDITABLE_FIELD_COLOR);
    }

    private static void initSelectionAsEditor(ComboBoxSelection selection, Color color) {
        selection.setEditable(true);
        selection.setFocusable(true);
        selection.setMonospacedFont();
        selection.switchLabelToBold();
        selection.biggerText(5);
        selection.storeAsStandardFontSize();
        selection.storeAsStandardLabelFontSize();
        selection.setBackgroundColor(color);
        selection.setRedCaretColor();
    }

    public static void initSelectionAsViewer(ComboBoxSelection selection) {
        selection.setEditable(false);
        selection.setFocusable(true);
        selection.setMonospacedFont();
        selection.switchLabelToBold();
        selection.biggerText(5);
        selection.storeAsStandardFontSize();
        selection.storeAsStandardLabelFontSize();
        selection.setBackgroundColor(EDITABLE_FIELD_COLOR);
        selection.setRedCaretColor();
    }

    public static void initSelectionAsFocusableViewer(StringSelection selection) {
        initSelectionAsViewer(selection);
        selection.setFocusable(true);
    }

    public static void initSelectionAsFocusableViewer(TextAreaSelection selection) {
        initSelectionAsViewer(selection);
        selection.setFocusable(true);
    }

    /**
     * Erstellt eine feste StringSelection mit Titel und Inhalt, die zum Betrachten da ist.
     *
     * @param title
     *            Der anzuzeigende Titel.
     * @param content
     *            Der anzuzeigende Text.
     */
    public static StringSelection createViewerStringSelection(String title, String content) {
        StringSelection selection = new StringSelection(title);
        SelectionsHelper.initSelectionAsViewer(selection);
        selection.setFocusable(true); // sonst kann man nichts daraus kopieren
        selection.setText(content);
        return selection;
    }

}
