package de.duehl.swing.ui.dialogs.values;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Image;
import java.awt.Point;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.colors.Colorizer;

public class EnterTwoPositiveIntegerValuesDialog extends EnterTwoValuesDialog {

    /**
     * Konstruktor.
     *
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     * @param programImage
     *            Icon für den Dialog.
     * @param dialogTitle
     *            Titel des Dialogs.
     * @param firstQuestion
     *            Text der Frage über dem ersten Eingabefeld.
     * @param firstPresetting
     *            Vorgabe die im ersten Eingabefeld angezeigt werden soll.
     * @param secondQuestion
     *            Text der Frage über dem zweiten Eingabefeld.
     * @param secondPresetting
     *            Vorgabe die im zweiten Eingabefeld angezeigt werden soll.
     */
    public EnterTwoPositiveIntegerValuesDialog(Point parentLocation, Image programImage,
            String dialogTitle, String firstQuestion, String firstPresetting, String secondQuestion,
            String secondPresetting) {
        this(null, parentLocation, programImage, dialogTitle, firstQuestion, firstPresetting,
                secondQuestion, secondPresetting);
    }

    /**
     * Konstruktor.
     *
     * @param colorizer
     *            Farbverwaltung für die Gui.
     * @param parentLocation
     *            Position des Rahmens der Oberfläche, vor der dieser Dialog erzeugt wird.
     * @param programImage
     *            Icon für den Dialog.
     * @param dialogTitle
     *            Titel des Dialogs.
     * @param firstQuestion
     *            Text der Frage über dem ersten Eingabefeld.
     * @param firstPresetting
     *            Vorgabe die im ersten Eingabefeld angezeigt werden soll.
     * @param secondQuestion
     *            Text der Frage über dem zweiten Eingabefeld.
     * @param secondPresetting
     *            Vorgabe die im zweiten Eingabefeld angezeigt werden soll.
     */
    public EnterTwoPositiveIntegerValuesDialog(Colorizer colorizer, Point parentLocation,
            Image programImage, String dialogTitle, String firstQuestion, String firstPresetting,
            String secondQuestion, String secondPresetting) {
        super(colorizer, parentLocation, programImage, dialogTitle, firstQuestion, firstPresetting,
                secondQuestion, secondPresetting);
    }

    @Override
    protected void apply() {
        String value1 = getFirstValue();
        String value2 = getSecondValue();
        if (value1.isEmpty()) {
            applyFailure("Der erste Wert darf nicht leer sein.");
        }
        else if (value2.isEmpty()) {
            applyFailure("Der zweite Wert darf nicht leer sein.");
        }
        else if (!NumberString.isDigitSequence(value1)) {
            applyFailure("Der erste Wert darf nur aus Ziffern bestehen.");
        }
        else if (!NumberString.isDigitSequence(value2)) {
            applyFailure("Der zweite Wert darf nur aus Ziffern bestehen.");
        }
        else {
            applyOk();
        }
    }

}
