package de.duehl.swing.ui.elements.textfield;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für ein Objekt, dass auf Eingabe von Enter reagiert.
 *
 * @version 1.01     2017-12-15
 * @author Christian Dühl
 */

public interface EnterReaktor {

    /**
     * Reagiert auf die Eingabe von Enter im Textfeld
     *
     * @param text
     *            Der im Textfeld eingegebene, getrimmte Text.
     */
    void enterPressed(String text);

}
