package de.duehl.swing.ui.elements.textfield;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JTextField;

/**
 * Diese Klasse stellt ein JTextField dar, dem man mitgeben kann, wie auf Eingabe von Enter
 * reagiert wird.
 *
 * @version 1.01     2018-04-05
 * @author Christian Dühl
 */

public class EnterTextField extends JTextField {

    private static final long serialVersionUID = 1L;

    /** Reagiert auf die Eingabe von Enter. */
    private final EnterReaktor enterReaktor;

    /**
     * Konstruktor.
     *
     * @param enterReaktor
     *            Reagiert auf die Eingabe von Enter.
     */
    public EnterTextField(EnterReaktor enterReaktor) {
        this("", enterReaktor);
    }

    /**
     * Konstruktor.
     *
     * @param text
     *            Anzuzeigender Text.
     * @param enterReaktor
     *            Reagiert auf die Eingabe von Enter.
     */
    public EnterTextField(String text, EnterReaktor enterReaktor) {
        super(text);
        this.enterReaktor = enterReaktor;
        addKeyListener(createKeyListener());
    }

    /** Gibt den eingegebenen Text getrimmt zurück. */
    public String getTrimmedText() {
        String text = getText();
        return text.trim();
    }

    private KeyListener createKeyListener() {
        return new KeyListener() {
            @Override
            public void keyTyped(KeyEvent event) {
            }

            @Override
            public void keyPressed(KeyEvent event) {
                int key = event.getKeyCode();

                if (key == KeyEvent.VK_ENTER && event.getModifiersEx() == 0) {
                    enterReaktor.enterPressed(getTrimmedText());
                }
            }

            @Override
            public void keyReleased(KeyEvent event) {
            }
        };
    }

}
