package de.duehl.swing.ui.filter.dialog;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für eine Klasse, die Zeilen im Filterdialog hinzufügen und entfernen
 * kann.
 *
 * @version 1.01     2020-11-03
 * @author Christian Dühl
 */

public interface FilterCombinationLineHandler<Data, Type>  {

    /** Entfernt die angegebene Zeile aus der Liste und aus der Oberfläche: */
    void removeLine(FilterCombinationLine<Data, Type>  line);

    /** Fügt eine Zeile unter der angegebene Zeile hinzu: */
    void addLine(FilterCombinationLine<Data, Type>  line);

}
