package de.duehl.swing.ui.filter.method.combination;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;

/**
 * Diese Klasse repräsentiert eine Liste von Kombinationselementen, also eine Grundlage für eine
 * kombinierte Filtermethode.
 *
 * @version 1.01     2021-04-27
 * @author Christian Dühl
 */

public class CombinationElementList<Data> implements Iterable<CombinationElement<Data>> {

    /** Liste mit den Kombinationselementen. */
    private List<CombinationElement<Data>> elements;

    public CombinationElementList() {
        elements = new ArrayList<CombinationElement<Data>>();
    }

    @Override
    public Iterator<CombinationElement<Data>> iterator() {
        return elements.iterator();
    }

    public CombinationElement<Data> get(int index) {
        return elements.get(index);
    }

    public void add(CombinationElement<Data> element) {
        elements.add(element);
    }

    public int size() {
        return elements.size();
    }

    public CombinationElement<Data> remove(int index) {
        return elements.remove(index);
    }

    public void add(int index, CombinationElement<Data> element) {
        elements.add(index, element);
    }

    @Override
    public String toString() {
        return "CombinationElementList:\n"
                + CollectionsHelper.listListNice(elements, 0);
    }

}
